<?php
/**
 * Video Embed Component
 * Embed YouTube or Vimeo videos
 * 
 * Attributes:
 * - url: Video URL (YouTube or Vimeo)
 * - title: Video title
 * - description: Optional description
 * - aspect: Aspect ratio (16by9, 4by3, 1by1)
 */

$url = $url ?? 'https://www.youtube.com/watch?v=dQw4w9WgXcQ';
$title = $title ?? '';
$description = $description ?? '';
$aspect = $aspect ?? '16by9';

// Parse YouTube/Vimeo URL
$embedUrl = '';
if (preg_match('/youtube\.com\/watch\?v=([^&]+)/', $url, $matches)) {
    $embedUrl = 'https://www.youtube.com/embed/' . $matches[1];
} elseif (preg_match('/youtu\.be\/([^?]+)/', $url, $matches)) {
    $embedUrl = 'https://www.youtube.com/embed/' . $matches[1];
} elseif (preg_match('/vimeo\.com\/(\d+)/', $url, $matches)) {
    $embedUrl = 'https://player.vimeo.com/video/' . $matches[1];
} else {
    $embedUrl = $url;
}
?>
<section class="section">
    <div class="container">
        <?php if ($title): ?>
            <h2 class="title is-3 has-text-centered mb-4"><?= htmlspecialchars($title) ?></h2>
        <?php endif; ?>
        <?php if ($description): ?>
            <p class="subtitle has-text-centered mb-5"><?= htmlspecialchars($description) ?></p>
        <?php endif; ?>

        <div class="columns is-centered">
            <div class="column is-full-mobile is-10-tablet">
                <figure class="image is-<?= htmlspecialchars($aspect) ?>">
                    <iframe class="has-ratio" src="<?= htmlspecialchars($embedUrl) ?>" allowfullscreen
                        style="border-radius: 8px; box-shadow: 0 10px 30px rgba(0,0,0,0.2);">
                    </iframe>
                </figure>
            </div>
        </div>
    </div>
</section>