<?php
/**
 * Timeline Component
 * Vertical timeline for history/process
 * 
 * Attributes:
 * - title: Section title
 * - events: JSON array with year, title, description
 */

$sectionTitle = $title ?? 'Our Journey';
$events = $events ?? [];

if (is_string($events)) {
    $decoded = json_decode(html_entity_decode($events), true);
    $events = is_array($decoded) ? $decoded : [];
}

if (empty($events)) {
    $events = [
        ['year' => '2015', 'title' => 'Company Founded', 'description' => 'Started with a vision to transform the industry.'],
        ['year' => '2017', 'title' => 'First Major Client', 'description' => 'Secured our first Fortune 500 client.'],
        ['year' => '2019', 'title' => 'Global Expansion', 'description' => 'Opened offices in 5 countries.'],
        ['year' => '2021', 'title' => 'Industry Award', 'description' => 'Recognized as industry leader.'],
        ['year' => '2023', 'title' => 'New Horizons', 'description' => 'Launched next-generation platform.']
    ];
}
?>
<section class="section">
    <div class="container">
        <h2 class="title is-2 has-text-centered mb-6"><?= htmlspecialchars($sectionTitle) ?></h2>

        <div class="columns is-centered">
            <div class="column is-full-mobile is-8-tablet">
                <div class="timeline">
                    <?php foreach ($events as $i => $event): ?>
                        <div class="timeline-item">
                            <div class="timeline-marker is-primary <?= $i === 0 ? 'is-icon' : '' ?>">
                                <?php if ($i === 0): ?>
                                    <i class="fas fa-flag"></i>
                                <?php endif; ?>
                            </div>
                            <div class="timeline-content">
                                <p class="heading has-text-primary has-text-weight-bold">
                                    <?= htmlspecialchars($event['year'] ?? '') ?>
                                </p>
                                <p class="title is-5"><?= htmlspecialchars($event['title'] ?? '') ?></p>
                                <p><?= htmlspecialchars($event['description'] ?? '') ?></p>
                            </div>
                        </div>
                    <?php endforeach; ?>
                </div>
            </div>
        </div>
    </div>
</section>

<style>
    .timeline {
        position: relative;
        padding-left: 2rem;
    }

    .timeline::before {
        content: '';
        position: absolute;
        left: 0;
        top: 0;
        bottom: 0;
        width: 3px;
        background: #dbdbdb;
    }

    .timeline-item {
        position: relative;
        padding-bottom: 2rem;
    }

    .timeline-marker {
        position: absolute;
        left: -2rem;
        width: 1rem;
        height: 1rem;
        background: #3273dc;
        border-radius: 50%;
        transform: translateX(-50%);
    }

    .timeline-marker.is-icon {
        width: 2rem;
        height: 2rem;
        display: flex;
        align-items: center;
        justify-content: center;
        color: white;
    }

    .timeline-content {
        padding-left: 1rem;
    }
</style>