<?php
/**
 * Testimonials Component
 * Display customer testimonials in a carousel/grid
 * 
 * Attributes:
 * - title: Section title
 * - testimonials: JSON array with quote, author, role, image
 */

$sectionTitle = $title ?? 'What Our Clients Say';
$testimonials = $testimonials ?? [];

if (is_string($testimonials)) {
    $decoded = json_decode(html_entity_decode($testimonials), true);
    $testimonials = is_array($decoded) ? $decoded : [];
}

if (empty($testimonials)) {
    $testimonials = [
        ['quote' => 'Excellent service and support. Highly recommended!', 'author' => 'Sarah Johnson', 'role' => 'CEO, TechCorp', 'image' => 'https://i.pravatar.cc/100?u=1'],
        ['quote' => 'The best investment we made for our business.', 'author' => 'Michael Chen', 'role' => 'Founder, StartupXYZ', 'image' => 'https://i.pravatar.cc/100?u=2'],
        ['quote' => 'Professional team with outstanding results.', 'author' => 'Emily Davis', 'role' => 'Director, GlobalCo', 'image' => 'https://i.pravatar.cc/100?u=3']
    ];
}
?>
<section class="section has-background-light">
    <div class="container">
        <h2 class="title is-2 has-text-centered mb-6"><?= htmlspecialchars($sectionTitle) ?></h2>

        <div class="columns">
            <?php foreach ($testimonials as $t): ?>
                <div class="column is-full-mobile is-4-tablet">
                    <div class="box" style="height: 100%;">
                        <article class="media">
                            <div class="media-left">
                                <figure class="image is-64x64">
                                    <img class="is-rounded"
                                        src="<?= htmlspecialchars($t['image'] ?? 'https://i.pravatar.cc/100') ?>" alt="">
                                </figure>
                            </div>
                            <div class="media-content">
                                <p class="title is-5"><?= htmlspecialchars($t['author'] ?? '') ?></p>
                                <p class="subtitle is-6 has-text-grey"><?= htmlspecialchars($t['role'] ?? '') ?></p>
                            </div>
                        </article>
                        <div class="content mt-4">
                            <p class="is-italic">"<?= htmlspecialchars($t['quote'] ?? '') ?>"</p>
                        </div>
                        <div class="has-text-warning">
                            <i class="fas fa-star"></i>
                            <i class="fas fa-star"></i>
                            <i class="fas fa-star"></i>
                            <i class="fas fa-star"></i>
                            <i class="fas fa-star"></i>
                        </div>
                    </div>
                </div>
            <?php endforeach; ?>
        </div>
    </div>
</section>