<?php
/**
 * Tabs Component
 * Tabbed content sections
 * 
 * Attributes:
 * - tabs: JSON array with title and content
 */

$tabs = $tabs ?? [];
if (is_string($tabs)) {
    $tabs = json_decode(html_entity_decode($tabs), true) ?: [];
}

if (empty($tabs)) {
    $tabs = [
        ['title' => 'Overview', 'content' => '<p>This is the overview content. You can add any HTML here.</p>'],
        ['title' => 'Features', 'content' => '<ul><li>Feature 1</li><li>Feature 2</li><li>Feature 3</li></ul>'],
        ['title' => 'Specifications', 'content' => '<p>Technical specifications and details go here.</p>']
    ];
}
$tabId = 'tabs-' . uniqid();
?>
<section class="section">
    <div class="container">
        <div class="tabs is-centered is-boxed is-toggle-rounded is-small-mobile is-medium-tablet" id="<?= $tabId ?>">
            <ul>
                <?php foreach ($tabs as $i => $tab): ?>
                    <li class="<?= $i === 0 ? 'is-active' : '' ?>" data-tab="<?= $i ?>">
                        <a><?= htmlspecialchars($tab['title'] ?? 'Tab ' . ($i + 1)) ?></a>
                    </li>
                <?php endforeach; ?>
            </ul>
        </div>

        <div class="tab-contents">
            <?php foreach ($tabs as $i => $tab): ?>
                <div class="tab-content box <?= $i === 0 ? '' : 'is-hidden' ?>" data-content="<?= $i ?>">
                    <div class="content">
                        <?= $tab['content'] ?? '' ?>
                    </div>
                </div>
            <?php endforeach; ?>
        </div>
    </div>
</section>

<script>
    document.querySelectorAll('#<?= $tabId ?> li').forEach(tab => {
        tab.addEventListener('click', function () {
            const tabIndex = this.dataset.tab;

            // Update active tab
            document.querySelectorAll('#<?= $tabId ?> li').forEach(t => t.classList.remove('is-active'));
            this.classList.add('is-active');

            // Show corresponding content
            document.querySelectorAll('.tab-content').forEach(c => c.classList.add('is-hidden'));
            document.querySelector('.tab-content[data-content="' + tabIndex + '"]').classList.remove('is-hidden');
        });
    });
</script>