<?php
/**
 * Showcase Component
 * Displays a grid of feature cards
 * 
 * Attributes:
 * - title (optional): Section title
 * - items (optional): JSON array of items with title, description, tag
 */

// Get attributes with defaults
$sectionTitle = $title ?? 'Showcase';
$items = $items ?? [];

// Handle items - could be array or JSON string
if (is_string($items)) {
    $decoded = json_decode(html_entity_decode($items), true);
    $items = is_array($decoded) ? $decoded : [];
}

// Default items if none provided
if (empty($items)) {
    $items = [
        ['title' => 'Feature 1', 'description' => 'Description for feature 1', 'tag' => 'New'],
        ['title' => 'Feature 2', 'description' => 'Description for feature 2', 'tag' => 'Popular'],
        ['title' => 'Feature 3', 'description' => 'Description for feature 3', 'tag' => 'Pro'],
        ['title' => 'Feature 4', 'description' => 'Description for feature 4', 'tag' => 'Premium']
    ];
}
?>
<section class="section showcase-section">
    <div class="container">
        <?php if ($sectionTitle): ?>
            <h2 class="title is-2 has-text-centered mb-6"><?= htmlspecialchars($sectionTitle) ?></h2>
        <?php endif; ?>

        <div class="columns is-multiline">
            <?php foreach ($items as $item): ?>
                <div class="column is-one-quarter">
                    <div class="card showcase-card">
                        <div class="card-content">
                            <p class="title is-5">
                                <?= htmlspecialchars($item['title'] ?? '') ?>
                            </p>
                            <div class="content">
                                <?= htmlspecialchars($item['description'] ?? '') ?>
                            </div>
                        </div>
                        <?php if (!empty($item['tag'])): ?>
                            <footer class="card-footer">
                                <p class="card-footer-item">
                                    <span class="tag is-primary is-light">
                                        <?= htmlspecialchars($item['tag']) ?>
                                    </span>
                                </p>
                            </footer>
                        <?php endif; ?>
                    </div>
                </div>
            <?php endforeach; ?>
        </div>
    </div>
</section>

<style>
    .showcase-card {
        height: 100%;
        display: flex;
        flex-direction: column;
        justify-content: space-between;
        transition: transform 0.2s, box-shadow 0.2s;
    }

    .showcase-card:hover {
        transform: translateY(-5px);
        box-shadow: 0 10px 20px rgba(0, 0, 0, 0.1);
    }
</style>