<?php
/**
 * Newsletter Component
 * Email subscription form
 * 
 * Attributes:
 * - title: Heading
 * - subtitle: Description
 * - button_text: Submit button text
 * - background: Background color (light, primary, dark)
 */

$title = $title ?? 'Subscribe to Our Newsletter';
$subtitle = $subtitle ?? 'Get the latest updates and offers directly in your inbox.';
$button_text = $button_text ?? 'Subscribe';
$background = $background ?? 'light';
?>
<section class="section has-background-<?= htmlspecialchars($background) ?>">
    <div class="container">
        <div class="columns is-centered">
            <div class="column is-full-mobile is-8-tablet is-6-desktop has-text-centered">
                <h2
                    class="title is-3 <?= $background === 'primary' || $background === 'dark' ? 'has-text-white' : '' ?>">
                    <?= htmlspecialchars($title) ?>
                </h2>
                <p
                    class="subtitle is-5 <?= $background === 'primary' || $background === 'dark' ? 'has-text-white-ter' : '' ?>">
                    <?= htmlspecialchars($subtitle) ?>
                </p>

                <form class="mt-5">
                    <div class="field has-addons has-addons-centered">
                        <div class="control is-expanded">
                            <input class="input is-medium" type="email" placeholder="Enter your email" required>
                        </div>
                        <div class="control">
                            <button type="submit" class="button is-primary is-medium">
                                <?= htmlspecialchars($button_text) ?>
                            </button>
                        </div>
                    </div>
                    <p
                        class="is-size-7 mt-3 <?= $background === 'primary' || $background === 'dark' ? 'has-text-white-ter' : 'has-text-grey' ?>">
                        <i class="fas fa-lock"></i> We respect your privacy. Unsubscribe at any time.
                    </p>
                </form>
            </div>
        </div>
    </div>
</section>