<?php
/**
 * FAQ Component
 * Accordion-style frequently asked questions
 * 
 * Attributes:
 * - title: Section title
 * - faqs: JSON array with question and answer
 */

$sectionTitle = $title ?? 'Frequently Asked Questions';
$faqs = $faqs ?? [];

if (is_string($faqs)) {
    $decoded = json_decode(html_entity_decode($faqs), true);
    $faqs = is_array($decoded) ? $decoded : [];
}

if (empty($faqs)) {
    $faqs = [
        ['question' => 'How do I get started?', 'answer' => 'Simply sign up for an account and follow our quick setup guide.'],
        ['question' => 'What payment methods do you accept?', 'answer' => 'We accept all major credit cards, PayPal, and bank transfers.'],
        ['question' => 'Can I cancel my subscription?', 'answer' => 'Yes, you can cancel anytime from your account settings.'],
        ['question' => 'Do you offer customer support?', 'answer' => 'Yes, we offer 24/7 customer support via email and live chat.']
    ];
}
$faqId = 'faq-' . uniqid();
?>
<section class="section">
    <div class="container">
        <h2 class="title is-2 has-text-centered mb-6"><?= htmlspecialchars($sectionTitle) ?></h2>

        <div class="columns is-centered">
            <div class="column is-full-mobile is-10-tablet is-8-desktop">
                <?php foreach ($faqs as $i => $faq): ?>
                    <div class="box faq-item mb-3" style="cursor: pointer;" onclick="toggleFaq(this)">
                        <div class="level is-mobile">
                            <div class="level-left">
                                <p class="title is-5 mb-0"><?= htmlspecialchars($faq['question'] ?? '') ?></p>
                            </div>
                            <div class="level-right">
                                <span class="icon faq-icon">
                                    <i class="fas fa-chevron-down"></i>
                                </span>
                            </div>
                        </div>
                        <div class="faq-answer mt-4" style="display: none;">
                            <p><?= htmlspecialchars($faq['answer'] ?? '') ?></p>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>
        </div>
    </div>
</section>

<style>
    .faq-item:hover {
        background-color: #f5f5f5;
    }

    .faq-item.is-active .faq-icon {
        transform: rotate(180deg);
    }

    .faq-icon {
        transition: transform 0.3s;
    }
</style>

<script>
    function toggleFaq(el) {
        el.classList.toggle('is-active');
        const answer = el.querySelector('.faq-answer');
        answer.style.display = answer.style.display === 'none' ? 'block' : 'none';
    }
</script>