<?php
/**
 * Content Section Component
 * Two-column layout with image and text
 * 
 * Attributes:
 * - title: Heading
 * - content: Text content (supports HTML)
 * - image: Image URL
 * - image_position: 'left' or 'right' (default: right)
 * - cta_text: Button text (optional)
 * - cta_link: Button link (optional)
 */

$title = $title ?? 'About Us';
$content = $content ?? 'We are a passionate team dedicated to delivering exceptional results. Our expertise spans multiple industries and technologies.';
$image = $image ?? 'https://picsum.photos/600/400?random=20';
$image_position = $image_position ?? 'right';
$cta_text = $cta_text ?? '';
$cta_link = $cta_link ?? '#';
?>
<section class="section">
    <div class="container">
        <div class="columns is-vcentered <?= $image_position === 'left' ? 'is-flex-direction-row-reverse' : '' ?>">
            <div class="column is-full-mobile is-6-tablet">
                <h2 class="title is-2"><?= htmlspecialchars($title) ?></h2>
                <div class="content is-medium">
                    <?= $content ?>
                </div>
                <?php if ($cta_text): ?>
                    <a href="<?= htmlspecialchars($cta_link) ?>" class="button is-primary is-medium">
                        <?= htmlspecialchars($cta_text) ?>
                    </a>
                <?php endif; ?>
            </div>
            <div class="column is-full-mobile is-6-tablet">
                <figure class="image">
                    <img src="<?= htmlspecialchars($image) ?>" alt="<?= htmlspecialchars($title) ?>"
                        style="border-radius: 8px; box-shadow: 0 10px 30px rgba(0,0,0,0.15);">
                </figure>
            </div>
        </div>
    </div>
</section>