<section class="section contact-form-section">
    <div class="container">
        <div class="columns is-centered">
            <div class="column is-two-thirds">
                <!-- Section Header -->
                <div class="has-text-centered mb-5">
                    <h2 class="title is-2"><?= htmlspecialchars($title ?? 'Contact Us') ?></h2>
                    <?php if (!empty($subtitle)): ?>
                        <p class="subtitle is-5 has-text-grey"><?= htmlspecialchars($subtitle) ?></p>
                    <?php endif; ?>
                </div>

                <!-- Contact Form -->
                <div class="box">
                    <form action="#" method="POST" class="contact-form">
                        <?php if (!empty($email_to)): ?>
                            <input type="hidden" name="email_to" value="<?= htmlspecialchars($email_to) ?>">
                        <?php endif; ?>

                        <div class="columns">
                            <div class="column">
                                <div class="field">
                                    <label class="label">Full Name <span class="has-text-danger">*</span></label>
                                    <div class="control has-icons-left">
                                        <input class="input" type="text" name="name" placeholder="John Doe" required>
                                        <span class="icon is-small is-left">
                                            <i class="fas fa-user"></i>
                                        </span>
                                    </div>
                                </div>
                            </div>
                            <div class="column">
                                <div class="field">
                                    <label class="label">Email Address <span class="has-text-danger">*</span></label>
                                    <div class="control has-icons-left">
                                        <input class="input" type="email" name="email" placeholder="john@example.com"
                                            required>
                                        <span class="icon is-small is-left">
                                            <i class="fas fa-envelope"></i>
                                        </span>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="columns">
                            <div class="column">
                                <div class="field">
                                    <label class="label">Phone Number</label>
                                    <div class="control has-icons-left">
                                        <input class="input" type="tel" name="phone" placeholder="+1 (555) 123-4567">
                                        <span class="icon is-small is-left">
                                            <i class="fas fa-phone"></i>
                                        </span>
                                    </div>
                                </div>
                            </div>
                            <div class="column">
                                <div class="field">
                                    <label class="label">Case Type <span class="has-text-danger">*</span></label>
                                    <div class="control has-icons-left">
                                        <div class="select is-fullwidth">
                                            <select name="case_type" required>
                                                <option value="">Select a Practice Area</option>
                                                <option value="corporate">Corporate Law</option>
                                                <option value="family">Family Law</option>
                                                <option value="litigation">Civil Litigation</option>
                                                <option value="criminal">Criminal Defense</option>
                                                <option value="estate">Estate Planning</option>
                                                <option value="immigration">Immigration</option>
                                                <option value="other">Other</option>
                                            </select>
                                        </div>
                                        <span class="icon is-small is-left">
                                            <i class="fas fa-gavel"></i>
                                        </span>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="field">
                            <label class="label">Your Message <span class="has-text-danger">*</span></label>
                            <div class="control">
                                <textarea class="textarea" name="message" rows="5"
                                    placeholder="Please describe your legal matter..." required></textarea>
                            </div>
                        </div>

                        <div class="field">
                            <div class="control">
                                <label class="checkbox">
                                    <input type="checkbox" name="privacy" required>
                                    I agree to the <a href="/privacy">Privacy Policy</a> and consent to being contacted.
                                </label>
                            </div>
                        </div>

                        <div class="field mt-5">
                            <div class="control">
                                <button type="submit" class="button is-primary is-medium is-fullwidth">
                                    <span class="icon">
                                        <i class="fas fa-paper-plane"></i>
                                    </span>
                                    <span>Request Free Consultation</span>
                                </button>
                            </div>
                        </div>
                    </form>
                </div>

                <p class="has-text-centered has-text-grey is-size-7 mt-4">
                    <i class="fas fa-lock"></i> Your information is secure and confidential.
                </p>
            </div>
        </div>
    </div>
</section>

<style>
    .contact-form-section {
        background: #f8f9fa;
    }

    .contact-form-section .box {
        border-top: 4px solid var(--primary, #1a1a2e);
        box-shadow: 0 4px 16px rgba(0, 0, 0, 0.08);
    }

    .contact-form .input:focus,
    .contact-form .textarea:focus,
    .contact-form .select select:focus {
        border-color: var(--primary, #1a1a2e);
        box-shadow: 0 0 0 2px rgba(26, 26, 46, 0.1);
    }
</style>