<?php
/**
 * Cards Grid Component
 * Generic card grid layout
 * 
 * Attributes:
 * - title: Section title
 * - cards: JSON array with image, title, description, link, badge
 * - columns: Number of columns (2, 3, 4)
 */

$sectionTitle = $title ?? '';
$columns = $columns ?? 3;
$cards = $cards ?? [];

if (is_string($cards)) {
    $cards = json_decode(html_entity_decode($cards), true) ?: [];
}

if (empty($cards)) {
    $cards = [
        ['image' => 'https://picsum.photos/400/300?random=30', 'title' => 'Card Title 1', 'description' => 'Short description for this card.', 'link' => '#', 'badge' => 'New'],
        ['image' => 'https://picsum.photos/400/300?random=31', 'title' => 'Card Title 2', 'description' => 'Short description for this card.', 'link' => '#'],
        ['image' => 'https://picsum.photos/400/300?random=32', 'title' => 'Card Title 3', 'description' => 'Short description for this card.', 'link' => '#', 'badge' => 'Popular'],
        ['image' => 'https://picsum.photos/400/300?random=33', 'title' => 'Card Title 4', 'description' => 'Short description for this card.', 'link' => '#'],
        ['image' => 'https://picsum.photos/400/300?random=34', 'title' => 'Card Title 5', 'description' => 'Short description for this card.', 'link' => '#'],
        ['image' => 'https://picsum.photos/400/300?random=35', 'title' => 'Card Title 6', 'description' => 'Short description for this card.', 'link' => '#']
    ];
}

$colClass = match ((int) $columns) {
    2 => 'is-6',
    4 => 'is-3',
    default => 'is-4'
};
?>
<section class="section">
    <div class="container">
        <?php if ($sectionTitle): ?>
            <h2 class="title is-2 has-text-centered mb-6"><?= htmlspecialchars($sectionTitle) ?></h2>
        <?php endif; ?>

        <div class="columns is-multiline">
            <?php foreach ($cards as $card): ?>
                <div class="column <?= $colClass ?>">
                    <div class="card grid-card" style="height: 100%;">
                        <?php if (!empty($card['image'])): ?>
                            <div class="card-image">
                                <figure class="image is-4by3">
                                    <img src="<?= htmlspecialchars($card['image']) ?>"
                                        alt="<?= htmlspecialchars($card['title'] ?? '') ?>" style="object-fit: cover;">
                                </figure>
                                <?php if (!empty($card['badge'])): ?>
                                    <span class="tag is-primary" style="position: absolute; top: 10px; right: 10px;">
                                        <?= htmlspecialchars($card['badge']) ?>
                                    </span>
                                <?php endif; ?>
                            </div>
                        <?php endif; ?>
                        <div class="card-content">
                            <p class="title is-5"><?= htmlspecialchars($card['title'] ?? '') ?></p>
                            <p class="content"><?= htmlspecialchars($card['description'] ?? '') ?></p>
                        </div>
                        <?php if (!empty($card['link'])): ?>
                            <footer class="card-footer">
                                <a href="<?= htmlspecialchars($card['link']) ?>" class="card-footer-item">
                                    Learn More <i class="fas fa-arrow-right ml-2"></i>
                                </a>
                            </footer>
                        <?php endif; ?>
                    </div>
                </div>
            <?php endforeach; ?>
        </div>
    </div>
</section>

<style>
    .grid-card {
        transition: transform 0.3s, box-shadow 0.3s;
        position: relative;
    }

    .grid-card:hover {
        transform: translateY(-5px);
        box-shadow: 0 10px 30px rgba(0, 0, 0, 0.15);
    }
</style>