<?php
/**
 * Blog Cards Component
 * Display blog post cards
 * 
 * Attributes:
 * - title: Section title
 * - posts: JSON array with image, title, excerpt, date, author, link
 */

$sectionTitle = $title ?? 'Latest Blog Posts';
$posts = $posts ?? [];

if (is_string($posts)) {
    $decoded = json_decode(html_entity_decode($posts), true);
    $posts = is_array($decoded) ? $decoded : [];
}

if (empty($posts)) {
    $posts = [
        ['image' => 'https://picsum.photos/400/250?random=10', 'title' => '10 Tips for Better Productivity', 'excerpt' => 'Learn how to maximize your daily output with these proven strategies.', 'date' => 'Jan 5, 2024', 'author' => 'John Doe', 'link' => '#'],
        ['image' => 'https://picsum.photos/400/250?random=11', 'title' => 'The Future of Technology', 'excerpt' => 'Exploring emerging trends that will shape our world.', 'date' => 'Jan 3, 2024', 'author' => 'Jane Smith', 'link' => '#'],
        ['image' => 'https://picsum.photos/400/250?random=12', 'title' => 'Building Strong Teams', 'excerpt' => 'Key principles for creating high-performing teams.', 'date' => 'Jan 1, 2024', 'author' => 'Mike Johnson', 'link' => '#']
    ];
}
?>
<section class="section">
    <div class="container">
        <h2 class="title is-2 has-text-centered mb-6"><?= htmlspecialchars($sectionTitle) ?></h2>

        <div class="columns">
            <?php foreach ($posts as $post): ?>
                <div class="column is-4">
                    <div class="card blog-card" style="height: 100%;">
                        <div class="card-image">
                            <figure class="image is-16by9">
                                <img src="<?= htmlspecialchars($post['image'] ?? '') ?>"
                                    alt="<?= htmlspecialchars($post['title'] ?? '') ?>" style="object-fit: cover;">
                            </figure>
                        </div>
                        <div class="card-content">
                            <p class="is-size-7 has-text-grey mb-2">
                                <span class="icon is-small"><i class="fas fa-calendar"></i></span>
                                <?= htmlspecialchars($post['date'] ?? '') ?>
                                <span class="mx-2">•</span>
                                <span class="icon is-small"><i class="fas fa-user"></i></span>
                                <?= htmlspecialchars($post['author'] ?? '') ?>
                            </p>
                            <p class="title is-5">
                                <a href="<?= htmlspecialchars($post['link'] ?? '#') ?>" class="has-text-dark">
                                    <?= htmlspecialchars($post['title'] ?? '') ?>
                                </a>
                            </p>
                            <p class="content"><?= htmlspecialchars($post['excerpt'] ?? '') ?></p>
                        </div>
                        <footer class="card-footer">
                            <a href="<?= htmlspecialchars($post['link'] ?? '#') ?>" class="card-footer-item">
                                Read More <i class="fas fa-arrow-right ml-2"></i>
                            </a>
                        </footer>
                    </div>
                </div>
            <?php endforeach; ?>
        </div>

        <div class="has-text-centered mt-5">
            <a href="/blog" class="button is-primary is-light">View All Posts</a>
        </div>
    </div>
</section>

<style>
    .blog-card {
        transition: transform 0.3s, box-shadow 0.3s;
    }

    .blog-card:hover {
        transform: translateY(-5px);
        box-shadow: 0 10px 30px rgba(0, 0, 0, 0.15);
    }
</style>