<?php
/**
 * Author Bio Component
 * Author profile card for blog posts
 * 
 * Attributes:
 * - name: Author name
 * - role: Author role/title
 * - image: Author photo URL
 * - bio: Author biography
 * - social: JSON array with platform and url
 */

$name = $name ?? 'John Doe';
$role = $role ?? 'Content Writer';
$image = $image ?? 'https://i.pravatar.cc/150?u=author';
$bio = $bio ?? 'A passionate writer with expertise in technology and business. With over 10 years of experience, I help companies tell their stories.';

$social = $social ?? [];
if (is_string($social)) {
    $social = json_decode(html_entity_decode($social), true) ?: [];
}

if (empty($social)) {
    $social = [
        ['platform' => 'twitter', 'url' => '#'],
        ['platform' => 'linkedin', 'url' => '#'],
        ['platform' => 'github', 'url' => '#']
    ];
}

$iconMap = [
    'twitter' => 'fab fa-twitter',
    'linkedin' => 'fab fa-linkedin-in',
    'github' => 'fab fa-github',
    'facebook' => 'fab fa-facebook-f',
    'instagram' => 'fab fa-instagram',
    'website' => 'fas fa-globe'
];
?>
<section class="section py-5">
    <div class="container">
        <div class="box">
            <article class="media">
                <div class="media-left">
                    <figure class="image is-128x128">
                        <img class="is-rounded" src="<?= htmlspecialchars($image) ?>"
                            alt="<?= htmlspecialchars($name) ?>">
                    </figure>
                </div>
                <div class="media-content">
                    <div class="content">
                        <p>
                            <strong class="is-size-4"><?= htmlspecialchars($name) ?></strong>
                            <br>
                            <small class="has-text-primary"><?= htmlspecialchars($role) ?></small>
                        </p>
                        <p><?= htmlspecialchars($bio) ?></p>
                    </div>

                    <?php if (!empty($social)): ?>
                        <div class="buttons are-small">
                            <?php foreach ($social as $s):
                                $icon = $iconMap[$s['platform']] ?? 'fas fa-link';
                                ?>
                                <a href="<?= htmlspecialchars($s['url'] ?? '#') ?>" class="button is-light" target="_blank">
                                    <span class="icon"><i class="<?= $icon ?>"></i></span>
                                </a>
                            <?php endforeach; ?>
                        </div>
                    <?php endif; ?>
                </div>
            </article>
        </div>
    </div>
</section>