<?php
require_once __DIR__ . '/bootstrap.php';

if (!\Core\Auth::check()) {
    header('Location: /admin/login.php');
    exit;
}

$pdo = $GLOBALS['pdo'];
$userId = $_SESSION['user_id'] ?? null;
if (!$userId) {
    header('Location: /admin/login.php');
    exit;
}

$errorMessage = null;

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $token = $_POST['csrf_token'] ?? '';
    if (!\Core\Auth::verifyCsrfToken($token)) {
        http_response_code(403);
        die('CSRF token validation failed.');
    }

    $password = trim($_POST['password'] ?? '');
    $passwordConfirm = trim($_POST['password_confirm'] ?? '');

    if ($password === '' || $passwordConfirm === '') {
        $errorMessage = 'Password and confirmation are required.';
    } elseif ($password !== $passwordConfirm) {
        $errorMessage = 'Passwords do not match.';
    } elseif (strlen($password) < 8) {
        $errorMessage = 'Password must be at least 8 characters long.';
    } elseif ($password === \Core\Auth::DEFAULT_PASSWORD) {
        $errorMessage = 'Please choose a password different from the default.';
    } else {
        $hash = password_hash($password, PASSWORD_DEFAULT);
        $stmt = $pdo->prepare("UPDATE users SET password = ?, updated_at = CURRENT_TIMESTAMP WHERE id = ?");
        $stmt->execute([$hash, $userId]);

        \Core\Auth::clearPasswordResetFlag();
        header('Location: /admin/index.php');
        exit;
    }
}

$pageTitle = 'Change Password';
$currentPage = '';

ob_start();
?>

<div class="columns">
    <div class="column is-6 is-offset-3">
        <div class="admin-card">
            <h2 class="card-header-title">
                <span class="icon mr-2"><i class="fas fa-lock"></i></span>
                Password Required
            </h2>
            <p class="mb-4">
                You must change the default admin password before continuing.
            </p>
            <form method="POST">
                <input type="hidden" name="csrf_token" value="<?= \Core\Auth::generateCsrfToken() ?>">
                <div class="field">
                    <label class="label">New Password</label>
                    <div class="control">
                        <input class="input" type="password" name="password" required>
                    </div>
                </div>
                <div class="field">
                    <label class="label">Confirm Password</label>
                    <div class="control">
                        <input class="input" type="password" name="password_confirm" required>
                    </div>
                </div>
                <div class="field">
                    <div class="control">
                        <button type="submit" class="button is-primary">
                            Update Password
                        </button>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>

<?php
$content = ob_get_clean();
include __DIR__ . '/layouts/admin_layout.php';
