<?php
/**
 * Component Preview
 * Renders a component with sample data for preview
 */
require_once __DIR__ . "/../../src/Core/Auth.php";
require_once __DIR__ . "/../../src/Core/Theme.php";
require_once __DIR__ . "/../../src/Core/Model.php";
require_once __DIR__ . "/../../src/Core/MultiTenancy.php";
require_once __DIR__ . "/../../src/Models/Meta.php";

// Auth check
if (!\Core\Auth::check()) {
    header('Location: /admin/login.php');
    exit;
}

// Database connection
$tenantId = \Core\MultiTenancy::getTenantId();
define('DB_PATH', \Core\MultiTenancy::getDatabasePath($tenantId));
try {
    $pdo = new PDO('sqlite:' . DB_PATH);
    \Core\Model::setPdo($pdo);
} catch (Exception $e) {
    die('DB Error: ' . $e->getMessage());
}

$componentName = $_GET['name'] ?? null;
$componentDir = __DIR__ . '/../../themes/default/components/';
$themeUrl = \Core\Theme::getCssUrl();

if (!$componentName) {
    die('Component name required');
}

$filePath = $componentDir . $componentName . '.php';
if (!file_exists($filePath)) {
    die('Component not found: ' . htmlspecialchars($componentName));
}

// Sample data for different components
$sampleData = [
    'hero' => [
        'title' => 'Welcome to Our Company',
        'subtitle' => 'We deliver exceptional results for our clients',
        'cta_text' => 'Get Started',
        'cta_link' => '/contact'
    ],
    'features' => [
        'title' => 'Our Services',
        'description' => 'What we offer to help you succeed.',
        'items' => [
            ['title' => 'Service One', 'description' => 'Description of the first service we offer.'],
            ['title' => 'Service Two', 'description' => 'Description of the second service we offer.'],
            ['title' => 'Service Three', 'description' => 'Description of the third service we offer.']
        ]
    ],
    'team' => [
        'title' => 'Our Team',
        'description' => 'Meet the people behind our success.',
        'member1_name' => 'John Doe',
        'member1_role' => 'CEO',
        'member1_image' => 'https://i.pravatar.cc/300?u=john',
        'member2_name' => 'Jane Smith',
        'member2_role' => 'CTO',
        'member2_image' => 'https://i.pravatar.cc/300?u=jane'
    ],
    'contact_form' => [
        'title' => 'Contact Us',
        'subtitle' => 'We\'d love to hear from you',
        'email_to' => 'info@example.com'
    ],
    'showcase' => [
        'title' => 'Featured Work'
    ]
];

// Get sample data for this component (or use empty defaults)
$data = $sampleData[$componentName] ?? [];

// Extract variables for the component
extract($data);
?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Preview: <?= htmlspecialchars(ucwords(str_replace('_', ' ', $componentName))) ?></title>
    <link rel="stylesheet" href="<?= $themeUrl ?>">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        .preview-header {
            background: #1a1a2e;
            color: white;
            padding: 0.75rem 1.5rem;
            display: flex;
            justify-content: space-between;
            align-items: center;
            position: sticky;
            top: 0;
            z-index: 1000;
        }

        .preview-header h1 {
            font-size: 1rem;
            font-weight: 600;
            margin: 0;
        }

        .preview-header .buttons {
            display: flex;
            gap: 0.5rem;
        }

        .preview-header .btn {
            background: rgba(255, 255, 255, 0.1);
            color: white;
            border: none;
            padding: 0.5rem 1rem;
            border-radius: 4px;
            cursor: pointer;
            font-size: 0.875rem;
            text-decoration: none;
        }

        .preview-header .btn:hover {
            background: rgba(255, 255, 255, 0.2);
        }

        .preview-info {
            background: #f5f5f5;
            padding: 1rem;
            border-bottom: 1px solid #ddd;
            font-size: 0.875rem;
        }

        .preview-info code {
            background: #e1e5eb;
            padding: 0.25rem 0.5rem;
            border-radius: 3px;
        }
    </style>
</head>

<body>
    <div class="preview-header">
        <h1>
            <i class="fas fa-eye"></i>
            Component Preview: <?= htmlspecialchars(ucwords(str_replace('_', ' ', $componentName))) ?>
        </h1>
        <div class="buttons">
            <a href="/admin/component-editor.php?name=<?= htmlspecialchars($componentName) ?>" class="btn">
                <i class="fas fa-edit"></i> Edit
            </a>
            <a href="/admin/components.php" class="btn">
                <i class="fas fa-arrow-left"></i> Back
            </a>
        </div>
    </div>

    <div class="preview-info">
        <strong>Shortcode:</strong> <code>[component:<?= htmlspecialchars($componentName) ?>]</code>
        &nbsp;|&nbsp;
        <strong>File:</strong> <code>/themes/default/components/<?= htmlspecialchars($componentName) ?>.php</code>
    </div>

    <main>
        <?php include $filePath; ?>
    </main>
</body>

</html>