# cms-ck

Modern, lightweight CMS for shared hosting. Think of it as a compact WordPress alternative with a strict component contract so AI tools can generate UI safely without touching the core engine.

## Highlights
- PHP 8.1+, SQLite, zero services required
- Shortcode-driven components in `themes/default/components`
- Admin panel, prompt generator, component playground
- JSON API per page at `/api/v1/{slug}`
- Static site export (SSG) + file cache

## Project Structure
```text
/public             Web root (router, admin, uploads)
/src                Core logic (Core, Models)
/themes             Themes, layouts, components
/plugins            Drop-in extensions
/tenants            Tenant SQLite databases
/cache              File cache
database.sqlite     Default database
```

## Quick Start (Shared Hosting)
1. Upload the project to your hosting folder (or subdomain root).
2. Ensure these are writable by the web server:
   - `public/uploads`
   - `cache`
   - `tenants`
   - `database.sqlite`
3. Copy `.env.example` to `.env` and edit if needed.
4. Visit `/admin` to run the first-time installer and create your admin user.

If your template database already has a default admin user, log in with:
- user: `admin`
- password: `admin123`
You will be forced to change the password on first login.

## Subdomain Setup (Apache)
Example vhost for `cms.digitaltamam.com`:
```apacheconf
<VirtualHost *:80>
    ServerName cms.digitaltamam.com
    DocumentRoot /var/www/cms-ck/public

    <Directory /var/www/cms-ck/public>
        AllowOverride All
        Require all granted
    </Directory>
</VirtualHost>
```

## Subdomain Setup (Nginx)
```nginx
server {
    server_name cms.digitaltamam.com;
    root /var/www/cms-ck/public;
    index index.php;

    location / {
        try_files $uri $uri/ /index.php?$query_string;
    }

    location ~ \.php$ {
        include fastcgi_params;
        fastcgi_param SCRIPT_FILENAME $document_root$fastcgi_script_name;
        fastcgi_pass unix:/run/php/php8.1-fpm.sock;
    }
}
```

## Configuration
Environment variables in `.env`:
- `DB_PATH` path to the template database (default: `database.sqlite`)
- `SITE_TITLE` default site title
- `DEBUG` `true` or `false`
- `BASE_DOMAIN` base domain for subdomain tenant routing (e.g. `digitaltamam.com`)
- `TENANT_MAP` JSON map of host to tenant id (overrides `BASE_DOMAIN` logic)

Multi-tenancy behavior:
- If `TENANT_MAP` contains the host, its value is used as the tenant id.
- Otherwise, if `BASE_DOMAIN` matches the host, the subdomain becomes the tenant id.
- The tenant database filename is `tenants/tenant_{tenantId}.sqlite`.

Example:
```env
BASE_DOMAIN="digitaltamam.com"
TENANT_MAP={"cms.digitaltamam.com":1,"demo.digitaltamam.com":"demo"}
```

## Development (Local)
```bash
composer install
php -S localhost:8000 -t public
```

## Open Source
This project is MIT licensed. See `LICENSE`.

## Packaging for Download
For releases, publish a clean zip that excludes:
- `vendor/`
- `cache/`
- `tenants/`
- `public/uploads/`
- `.env`

Release script:
```bash
chmod +x scripts/release.sh
./scripts/release.sh 1.0.0
```

## Notes
- Multi-tenancy routing supports subdomain mapping via `BASE_DOMAIN` and `TENANT_MAP`.
