# CLI Commands Reference

This document describes CLI commands for AI-Native CMS automation.

## Site Management

### Create New Site
```bash
php cli/create-site.php --preset=<preset> --name="<client_name>" [options]
```

**Options:**
- `--preset` - Industry template (lawyer, clinic, realtor, restaurant, pedagogue)
- `--name` - Client/business name
- `--color` - Primary brand color (hex, e.g., #1a1a2e)
- `--output` - Output directory (default: ./projects/<slug>)

**Example:**
```bash
php cli/create-site.php --preset=lawyer --name="Smith & Associates" --color="#1e3a5f"
```

---

### Add Component
```bash
php cli/add-component.php --name=<component_name> [--template=<base>]
```

Creates a new component in `themes/default/components/`.

**Example:**
```bash
php cli/add-component.php --name=appointment_form --template=contact_form
```

---

### List Available Presets
```bash
php cli/list-presets.php
```

Shows all available industry presets with descriptions.

---

### Generate Pages from Preset
```bash
php cli/generate-pages.php --preset=<preset> --target=<project_dir>
```

Generates all pages for a preset into the target project.

---

## Deployment

### Deploy to Remote Host
```bash
php cli/deploy.php --project=<name> --host=<ftp_host> --user=<ftp_user> --pass=<ftp_pass>
```

**Options:**
- `--project` - Project directory name
- `--host` - FTP/SFTP hostname
- `--user` - FTP username
- `--pass` - FTP password
- `--port` - Port (default: 21 for FTP, 22 for SFTP)
- `--path` - Remote path (default: /public_html)
- `--method` - Transfer method: ftp, sftp, rsync (default: ftp)

**Example:**
```bash
php cli/deploy.php --project=smith-associates --host=ftp.hostinger.com --user=u123456789 --pass=secret123 --path=/public_html
```

---

## Database

### Export Database
```bash
php cli/export-db.php --project=<name> --format=<sql|json>
```

### Import Database
```bash
php cli/import-db.php --project=<name> --file=<path>
```

---

## Component Management

### List Components
```bash
php cli/list-components.php [--category=<category>]
```

Categories: all, layout, content, form, media

### Component Info
```bash
php cli/component-info.php --name=<component_name>
```

Shows component attributes, defaults, and example usage.

---

## Workflow Example

Complete site creation workflow:

```bash
# 1. Create site from preset
php cli/create-site.php --preset=lawyer --name="Law Office" --color="#1a1a2e"

# 2. Navigate to project
cd projects/law-office

# 3. Start local server for testing
php -S localhost:8000 -t public

# 4. After customization, deploy
php cli/deploy.php --project=law-office --host=ftp.client.com --user=client --pass=secret
```

---

## For AI Agents

When using these commands in an AI workflow:

1. Read `.ai/schema.json` first for component reference
2. Use `create-site.php` with appropriate preset
3. Customize content in database or page editor
4. Deploy using `deploy.php`

All commands return JSON on success:
```json
{"success": true, "message": "Site created", "path": "/projects/law-office"}
```

On error:
```json
{"success": false, "error": "Missing required parameter: --name"}
```
