<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <?php
    if (isset($page['id'])) {
        echo \Core\SEO::getMetaTags($page['id'] ?? 0, 'page', $title ?? '');
        ?>
        <?php if ($trackingHead = \Models\Meta::get(0, 'site', 'tracking_head')): ?>
            <?= $trackingHead ?>
        <?php endif; ?>
        <?php
        echo \Core\SEO::getSchemaOrg($page['id'], 'page', $page);
    } else {
        echo "<title>" . $this->e($title ?? 'AI-Native CMS') . "</title>";
    }
    ?>
    <link rel="stylesheet" href="<?= \Core\Theme::getCssUrl() ?>">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <?php
    $brandColor = \Models\Meta::get(0, 'site', 'brand_color') ?: '#007bff';
    ?>
    <style>
        :root {
            --primary:
                <?= $brandColor ?>
            ;
        }

        .has-text-primary-custom {
            color: var(--primary) !important;
        }

        .is-primary-custom {
            background-color: var(--primary) !important;
            color: white !important;
        }
    </style>
</head>

<body class="has-animations">
    <?php if ($trackingBody = \Models\Meta::get(0, 'site', 'tracking_body')): ?>
        <?= $trackingBody ?>
    <?php endif; ?>
    <nav class="navbar is-light" role="navigation" aria-label="main navigation">
        <div class="container">
            <div class="navbar-brand">
                <a class="navbar-item" href="/">
                    <strong><?= $this->e(\Models\Meta::get(0, 'site', 'site_title') ?: 'AI-Native CMS') ?></strong>
                </a>

                <a role="button" class="navbar-burger" aria-label="menu" aria-expanded="false"
                    data-target="navbarBasic">
                    <span aria-hidden="true"></span>
                    <span aria-hidden="true"></span>
                    <span aria-hidden="true"></span>
                </a>
            </div>

            <div id="navbarBasic" class="navbar-menu">
                <div class="navbar-start">
                    <a class="navbar-item" href="/">Home</a>
                    <a class="navbar-item" href="/about">About Us</a>
                    <div class="navbar-item has-dropdown is-hoverable">
                        <a class="navbar-link">Practice Areas</a>
                        <div class="navbar-dropdown">
                            <a class="navbar-item" href="/corporate-law">Corporate Law</a>
                            <a class="navbar-item" href="/family-law">Family Law</a>
                            <a class="navbar-item" href="/litigation">Civil Litigation</a>
                            <hr class="navbar-divider">
                            <a class="navbar-item" href="/contact-law">Free Consultation</a>
                        </div>
                    </div>
                    <a class="navbar-item" href="/contact-law">Contact</a>
                </div>
                <div class="navbar-end">
                    <div class="navbar-item">
                        <div class="buttons">
                            <a class="button is-primary" href="/contact-law">
                                <span class="icon"><i class="fas fa-phone"></i></span>
                                <span><strong>Schedule Consultation</strong></span>
                            </a>
                            <a class="button is-light" href="/admin">
                                <span class="icon"><i class="fas fa-lock"></i></span>
                                <span>Admin</span>
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </nav>

    <main>
        <?= $this->section('content') ?>
    </main>

    <footer class="footer">
        <div class="content has-text-centered">
            <p>
                <strong>Built with AI-Native CMS</strong>. The source code is licensed
                <a href="http://opensource.org/licenses/mit-license.php">MIT</a>.
            </p>
            <?php \Core\Hook::doAction('theme_footer'); ?>
        </div>
    </footer>

    <script>
        document.addEventListener('DOMContentLoaded', () => {
            const $navbarBurgers = Array.prototype.slice.call(document.querySelectorAll('.navbar-burger'), 0);
            $navbarBurgers.forEach(el => {
                el.addEventListener('click', () => {
                    const target = el.dataset.target;
                    const $target = document.getElementById(target);
                    el.classList.toggle('is-active');
                    $target.classList.toggle('is-active');
                });
            });
        });
    </script>
</body>

</html>