<section class="section team-section">
    <div class="container">
        <!-- Section Header -->
        <div class="has-text-centered mb-6">
            <h2 class="title is-2"><?= htmlspecialchars($title ?? 'Our Team') ?></h2>
            <?php if (!empty($description)): ?>
                <p class="subtitle is-5 has-text-grey"><?= htmlspecialchars($description) ?></p>
            <?php endif; ?>
        </div>

        <!-- Team Members -->
        <div class="columns is-centered">
            <?php
            // Build members array from individual variables
            $members = [];
            for ($i = 1; $i <= 4; $i++) {
                $nameVar = "member{$i}_name";
                $roleVar = "member{$i}_role";
                $imageVar = "member{$i}_image";
                if (!empty($$nameVar)) {
                    $members[] = [
                        'name' => $$nameVar,
                        'role' => $$roleVar ?? '',
                        'image' => $$imageVar ?? '/uploads/placeholder-attorney.jpg'
                    ];
                }
            }

            foreach ($members as $member):
                ?>
                <div class="column is-full-mobile is-one-third-tablet">
                    <div class="card team-card">
                        <div class="card-image">
                            <figure class="image is-1by1">
                                <img src="<?= htmlspecialchars($member['image']) ?>"
                                    alt="<?= htmlspecialchars($member['name']) ?>" style="object-fit: cover;">
                            </figure>
                        </div>
                        <div class="card-content has-text-centered">
                            <p class="title is-4"><?= htmlspecialchars($member['name']) ?></p>
                            <p class="subtitle is-6 has-text-primary"><?= htmlspecialchars($member['role']) ?></p>
                        </div>
                    </div>
                </div>
            <?php endforeach; ?>
        </div>
    </div>
</section>

<style>
    .team-section {
        background: linear-gradient(to bottom, #f8f9fa, #ffffff);
    }

    .team-card {
        transition: transform 0.3s ease, box-shadow 0.3s ease;
        border-radius: 8px;
        overflow: hidden;
    }

    .team-card:hover {
        transform: translateY(-8px);
        box-shadow: 0 12px 24px rgba(0, 0, 0, 0.15);
    }

    .team-card .card-image img {
        border-bottom: 3px solid var(--primary, #1a1a2e);
    }
</style>