<?php
/**
 * Steps Component
 * Step-by-step process display
 * 
 * Attributes:
 * - title: Section title
 * - steps: JSON array with number, title, description, icon
 */

$sectionTitle = $title ?? 'How It Works';
$steps = $steps ?? [];

if (is_string($steps)) {
    $steps = json_decode(html_entity_decode($steps), true) ?: [];
}

if (empty($steps)) {
    $steps = [
        ['number' => '1', 'title' => 'Sign Up', 'description' => 'Create your free account in minutes.', 'icon' => 'fas fa-user-plus'],
        ['number' => '2', 'title' => 'Configure', 'description' => 'Set up your preferences and settings.', 'icon' => 'fas fa-cog'],
        ['number' => '3', 'title' => 'Launch', 'description' => 'Go live and start using the platform.', 'icon' => 'fas fa-rocket']
    ];
}
?>
<section class="section">
    <div class="container">
        <h2 class="title is-2 has-text-centered mb-6"><?= htmlspecialchars($sectionTitle) ?></h2>

        <div class="columns">
            <?php foreach ($steps as $i => $step): ?>
                <div class="column is-full-mobile has-text-centered">
                    <div class="step-icon mb-4">
                        <span class="icon is-large has-text-primary">
                            <i class="<?= htmlspecialchars($step['icon'] ?? 'fas fa-check') ?> fa-3x"></i>
                        </span>
                    </div>
                    <div class="step-number mb-3">
                        <span
                            class="tag is-primary is-large is-rounded"><?= htmlspecialchars($step['number'] ?? ($i + 1)) ?></span>
                    </div>
                    <h3 class="title is-4"><?= htmlspecialchars($step['title'] ?? '') ?></h3>
                    <p class="has-text-grey"><?= htmlspecialchars($step['description'] ?? '') ?></p>

                    <?php if ($i < count($steps) - 1): ?>
                        <div class="step-arrow is-hidden-mobile" style="position: absolute; right: -20px; top: 50px;">
                            <span class="icon is-large has-text-grey-light">
                                <i class="fas fa-arrow-right fa-2x"></i>
                            </span>
                        </div>
                    <?php endif; ?>
                </div>
            <?php endforeach; ?>
        </div>
    </div>
</section>

<style>
    .column {
        position: relative;
    }
</style>