<?php
/**
 * Stats/Counter Component
 * Display statistics with icons
 * 
 * Attributes:
 * - title: Section title (optional)
 * - stats: JSON array with value, label, icon
 */

$sectionTitle = $title ?? '';
$stats = $stats ?? [];

if (is_string($stats)) {
    $decoded = json_decode(html_entity_decode($stats), true);
    $stats = is_array($decoded) ? $decoded : [];
}

if (empty($stats)) {
    $stats = [
        ['value' => '500+', 'label' => 'Happy Clients', 'icon' => 'fas fa-users'],
        ['value' => '1,200+', 'label' => 'Projects Completed', 'icon' => 'fas fa-check-circle'],
        ['value' => '15+', 'label' => 'Years Experience', 'icon' => 'fas fa-award'],
        ['value' => '24/7', 'label' => 'Support Available', 'icon' => 'fas fa-headset']
    ];
}
?>
<section class="section has-background-primary has-text-white">
    <div class="container">
        <?php if ($sectionTitle): ?>
            <h2 class="title is-2 has-text-centered has-text-white mb-6"><?= htmlspecialchars($sectionTitle) ?></h2>
        <?php endif; ?>

        <div class="columns has-text-centered">
            <?php foreach ($stats as $stat): ?>
                <div class="column is-full-mobile">
                    <span class="icon is-large mb-3">
                        <i class="<?= htmlspecialchars($stat['icon'] ?? 'fas fa-star') ?> fa-3x"></i>
                    </span>
                    <p class="title is-1 has-text-white"><?= htmlspecialchars($stat['value'] ?? '0') ?></p>
                    <p class="subtitle is-5 has-text-white-ter"><?= htmlspecialchars($stat['label'] ?? '') ?></p>
                </div>
            <?php endforeach; ?>
        </div>
    </div>
</section>