<?php
/**
 * Social Share Component
 * Social media sharing buttons
 * 
 * Attributes:
 * - title: Share prompt text
 * - url: URL to share (defaults to current page)
 * - text: Share text/title
 * - size: Button size (small, normal, medium, large)
 * - show_labels: Show button labels
 */

$title = $title ?? 'Share this:';
$shareUrl = $url ?? (isset($_SERVER['REQUEST_URI']) ? $_SERVER['REQUEST_URI'] : '/');
$shareText = $text ?? 'Check this out!';
$size = $size ?? 'normal';
$show_labels = $show_labels ?? false;

$encodedUrl = urlencode($shareUrl);
$encodedText = urlencode($shareText);

$networks = [
    ['name' => 'Facebook', 'icon' => 'fab fa-facebook-f', 'color' => '#1877f2', 'url' => "https://www.facebook.com/sharer/sharer.php?u={$encodedUrl}"],
    ['name' => 'Twitter', 'icon' => 'fab fa-twitter', 'color' => '#1da1f2', 'url' => "https://twitter.com/intent/tweet?url={$encodedUrl}&text={$encodedText}"],
    ['name' => 'LinkedIn', 'icon' => 'fab fa-linkedin-in', 'color' => '#0077b5', 'url' => "https://www.linkedin.com/shareArticle?mini=true&url={$encodedUrl}&title={$encodedText}"],
    ['name' => 'WhatsApp', 'icon' => 'fab fa-whatsapp', 'color' => '#25d366', 'url' => "https://wa.me/?text={$encodedText}%20{$encodedUrl}"],
    ['name' => 'Email', 'icon' => 'fas fa-envelope', 'color' => '#666666', 'url' => "mailto:?subject={$encodedText}&body={$encodedUrl}"]
];
?>
<div class="social-share">
    <?php if ($title): ?>
        <span class="mr-3 has-text-weight-semibold"><?= htmlspecialchars($title) ?></span>
    <?php endif; ?>

    <div class="buttons are-<?= htmlspecialchars($size) ?>" style="display: inline-flex;">
        <?php foreach ($networks as $net): ?>
            <a href="<?= $net['url'] ?>" target="_blank" rel="noopener" class="button"
                style="background-color: <?= $net['color'] ?>; color: white; border: none;"
                title="Share on <?= $net['name'] ?>">
                <span class="icon"><i class="<?= $net['icon'] ?>"></i></span>
                <?php if ($show_labels): ?>
                    <span><?= $net['name'] ?></span>
                <?php endif; ?>
            </a>
        <?php endforeach; ?>
    </div>
</div>

<style>
    .social-share .button:hover {
        opacity: 0.9;
        transform: translateY(-2px);
    }

    .social-share .button {
        transition: all 0.2s;
    }
</style>