<?php
/**
 * Services Component
 * Service cards with icons
 * 
 * Attributes:
 * - title: Section title
 * - subtitle: Section description
 * - services: JSON array with icon, title, description, link
 */

$sectionTitle = $title ?? 'Our Services';
$sectionSubtitle = $subtitle ?? '';
$services = $services ?? [];

if (is_string($services)) {
    $decoded = json_decode(html_entity_decode($services), true);
    $services = is_array($decoded) ? $decoded : [];
}

if (empty($services)) {
    $services = [
        ['icon' => 'fas fa-laptop-code', 'title' => 'Web Development', 'description' => 'Custom websites and web applications built with modern technologies.', 'link' => '#'],
        ['icon' => 'fas fa-mobile-alt', 'title' => 'Mobile Apps', 'description' => 'Native and cross-platform mobile applications for iOS and Android.', 'link' => '#'],
        ['icon' => 'fas fa-cloud', 'title' => 'Cloud Solutions', 'description' => 'Scalable cloud infrastructure and migration services.', 'link' => '#'],
        ['icon' => 'fas fa-shield-alt', 'title' => 'Cybersecurity', 'description' => 'Protect your business with our security solutions.', 'link' => '#'],
        ['icon' => 'fas fa-chart-line', 'title' => 'Analytics', 'description' => 'Data-driven insights to grow your business.', 'link' => '#'],
        ['icon' => 'fas fa-headset', 'title' => 'Support', 'description' => '24/7 technical support and maintenance.', 'link' => '#']
    ];
}
?>
<section class="section">
    <div class="container">
        <div class="has-text-centered mb-6">
            <h2 class="title is-2"><?= htmlspecialchars($sectionTitle) ?></h2>
            <?php if ($sectionSubtitle): ?>
                <p class="subtitle is-5"><?= htmlspecialchars($sectionSubtitle) ?></p>
            <?php endif; ?>
        </div>

        <div class="columns is-multiline">
            <?php foreach ($services as $service): ?>
                <div class="column is-full-mobile is-4-tablet">
                    <div class="box service-box has-text-centered" style="height: 100%;">
                        <span class="icon is-large has-text-primary mb-4">
                            <i class="<?= htmlspecialchars($service['icon'] ?? 'fas fa-star') ?> fa-3x"></i>
                        </span>
                        <h3 class="title is-4"><?= htmlspecialchars($service['title'] ?? '') ?></h3>
                        <p class="mb-4"><?= htmlspecialchars($service['description'] ?? '') ?></p>
                        <?php if (!empty($service['link'])): ?>
                            <a href="<?= htmlspecialchars($service['link']) ?>" class="button is-primary is-light">
                                Learn More <i class="fas fa-arrow-right ml-2"></i>
                            </a>
                        <?php endif; ?>
                    </div>
                </div>
            <?php endforeach; ?>
        </div>
    </div>
</section>

<style>
    .service-box {
        transition: transform 0.3s, box-shadow 0.3s;
    }

    .service-box:hover {
        transform: translateY(-5px);
        box-shadow: 0 10px 30px rgba(0, 0, 0, 0.1);
    }
</style>