<?php
/**
 * Pricing Component
 * Displays pricing plans in a grid
 * 
 * Attributes:
 * - title: Section title
 * - plans: JSON array of plans with name, price, period, features, cta_text, cta_link, is_featured
 */

$sectionTitle = $title ?? 'Pricing Plans';
$plans = $plans ?? [];

if (is_string($plans)) {
    $decoded = json_decode(html_entity_decode($plans), true);
    $plans = is_array($decoded) ? $decoded : [];
}

if (empty($plans)) {
    $plans = [
        ['name' => 'Basic', 'price' => '$9', 'period' => '/month', 'features' => ['5 Users', '10GB Storage', 'Email Support'], 'cta_text' => 'Get Started', 'cta_link' => '#'],
        ['name' => 'Pro', 'price' => '$29', 'period' => '/month', 'features' => ['25 Users', '100GB Storage', 'Priority Support', 'API Access'], 'cta_text' => 'Go Pro', 'cta_link' => '#', 'is_featured' => true],
        ['name' => 'Enterprise', 'price' => '$99', 'period' => '/month', 'features' => ['Unlimited Users', '1TB Storage', '24/7 Support', 'Custom Integration'], 'cta_text' => 'Contact Us', 'cta_link' => '#']
    ];
}
?>
<section class="section">
    <div class="container">
        <h2 class="title is-2 has-text-centered mb-6"><?= htmlspecialchars($sectionTitle) ?></h2>

        <div class="columns is-centered">
            <?php foreach ($plans as $plan):
                $isFeatured = !empty($plan['is_featured']);
                ?>
                <div class="column is-full-mobile is-4-tablet">
                    <div class="box <?= $isFeatured ? 'has-background-primary-light' : '' ?>" style="height: 100%;">
                        <?php if ($isFeatured): ?>
                            <span class="tag is-primary is-medium mb-3">Most Popular</span>
                        <?php endif; ?>

                        <h3 class="title is-4"><?= htmlspecialchars($plan['name'] ?? '') ?></h3>

                        <p class="is-size-1 has-text-weight-bold has-text-primary">
                            <?= htmlspecialchars($plan['price'] ?? '') ?>
                            <span class="is-size-5 has-text-grey"><?= htmlspecialchars($plan['period'] ?? '') ?></span>
                        </p>

                        <hr>

                        <ul class="mb-5">
                            <?php foreach (($plan['features'] ?? []) as $feature): ?>
                                <li class="mb-2">
                                    <span class="icon has-text-success"><i class="fas fa-check"></i></span>
                                    <?= htmlspecialchars($feature) ?>
                                </li>
                            <?php endforeach; ?>
                        </ul>

                        <a href="<?= htmlspecialchars($plan['cta_link'] ?? '#') ?>"
                            class="button is-fullwidth <?= $isFeatured ? 'is-primary' : 'is-primary is-light' ?>">
                            <?= htmlspecialchars($plan['cta_text'] ?? 'Choose Plan') ?>
                        </a>
                    </div>
                </div>
            <?php endforeach; ?>
        </div>
    </div>
</section>