<?php
/**
 * Logo Cloud Component
 * Display client/partner logos
 * 
 * Attributes:
 * - title: Section title
 * - logos: JSON array with src, alt, link
 */

$sectionTitle = $title ?? 'Trusted By';
$logos = $logos ?? [];

if (is_string($logos)) {
    $decoded = json_decode(html_entity_decode($logos), true);
    $logos = is_array($decoded) ? $decoded : [];
}

if (empty($logos)) {
    $logos = [
        ['src' => 'https://via.placeholder.com/150x60?text=Logo+1', 'alt' => 'Company 1'],
        ['src' => 'https://via.placeholder.com/150x60?text=Logo+2', 'alt' => 'Company 2'],
        ['src' => 'https://via.placeholder.com/150x60?text=Logo+3', 'alt' => 'Company 3'],
        ['src' => 'https://via.placeholder.com/150x60?text=Logo+4', 'alt' => 'Company 4'],
        ['src' => 'https://via.placeholder.com/150x60?text=Logo+5', 'alt' => 'Company 5'],
        ['src' => 'https://via.placeholder.com/150x60?text=Logo+6', 'alt' => 'Company 6']
    ];
}
?>
<section class="section has-background-light">
    <div class="container">
        <p class="has-text-centered has-text-grey is-size-5 mb-5"><?= htmlspecialchars($sectionTitle) ?></p>

        <div class="columns is-multiline is-centered is-vcentered">
            <?php foreach ($logos as $logo): ?>
                <div class="column is-2 has-text-centered">
                    <?php if (!empty($logo['link'])): ?>
                        <a href="<?= htmlspecialchars($logo['link']) ?>" target="_blank">
                        <?php endif; ?>
                        <img src="<?= htmlspecialchars($logo['src'] ?? '') ?>"
                            alt="<?= htmlspecialchars($logo['alt'] ?? '') ?>"
                            style="max-height: 60px; opacity: 0.7; transition: opacity 0.3s;"
                            onmouseover="this.style.opacity='1'" onmouseout="this.style.opacity='0.7'">
                        <?php if (!empty($logo['link'])): ?>
                        </a>
                    <?php endif; ?>
                </div>
            <?php endforeach; ?>
        </div>
    </div>
</section>