<?php
/**
 * Footer Component
 * Full site footer with columns
 * 
 * Attributes:
 * - company_name: Company name
 * - company_description: Short description
 * - columns: JSON array of footer columns with title and links
 * - social_links: JSON array with icon and url
 * - copyright: Copyright text
 */

$company_name = $company_name ?? 'Company Name';
$company_description = $company_description ?? 'Building the future, one step at a time.';
$copyright = $copyright ?? '© ' . date('Y') . ' All rights reserved.';

$columns = $columns ?? [];
if (is_string($columns)) {
    $columns = json_decode(html_entity_decode($columns), true) ?: [];
}
if (empty($columns)) {
    $columns = [
        ['title' => 'Company', 'links' => [['text' => 'About Us', 'url' => '/about'], ['text' => 'Careers', 'url' => '/careers'], ['text' => 'Contact', 'url' => '/contact']]],
        ['title' => 'Services', 'links' => [['text' => 'Web Development', 'url' => '#'], ['text' => 'Mobile Apps', 'url' => '#'], ['text' => 'Consulting', 'url' => '#']]],
        ['title' => 'Resources', 'links' => [['text' => 'Blog', 'url' => '/blog'], ['text' => 'Documentation', 'url' => '#'], ['text' => 'FAQ', 'url' => '#']]]
    ];
}

$social_links = $social_links ?? [];
if (is_string($social_links)) {
    $social_links = json_decode(html_entity_decode($social_links), true) ?: [];
}
if (empty($social_links)) {
    $social_links = [
        ['icon' => 'fab fa-facebook-f', 'url' => '#'],
        ['icon' => 'fab fa-twitter', 'url' => '#'],
        ['icon' => 'fab fa-linkedin-in', 'url' => '#'],
        ['icon' => 'fab fa-instagram', 'url' => '#']
    ];
}
?>
<footer class="footer has-background-dark has-text-white-ter">
    <div class="container">
        <div class="columns">
            <div class="column is-4">
                <h3 class="title is-4 has-text-white"><?= htmlspecialchars($company_name) ?></h3>
                <p class="mb-4"><?= htmlspecialchars($company_description) ?></p>
                <div class="buttons">
                    <?php foreach ($social_links as $social): ?>
                        <a href="<?= htmlspecialchars($social['url'] ?? '#') ?>" class="button is-dark is-small"
                            target="_blank">
                            <span class="icon"><i class="<?= htmlspecialchars($social['icon'] ?? '') ?>"></i></span>
                        </a>
                    <?php endforeach; ?>
                </div>
            </div>

            <?php foreach ($columns as $col): ?>
                <div class="column">
                    <h4 class="title is-5 has-text-white"><?= htmlspecialchars($col['title'] ?? '') ?></h4>
                    <ul>
                        <?php foreach (($col['links'] ?? []) as $link): ?>
                            <li class="mb-2">
                                <a href="<?= htmlspecialchars($link['url'] ?? '#') ?>" class="has-text-grey-light">
                                    <?= htmlspecialchars($link['text'] ?? '') ?>
                                </a>
                            </li>
                        <?php endforeach; ?>
                    </ul>
                </div>
            <?php endforeach; ?>
        </div>

        <hr style="background: rgba(255,255,255,0.1);">

        <div class="columns">
            <div class="column">
                <p class="has-text-grey"><?= htmlspecialchars($copyright) ?></p>
            </div>
            <div class="column has-text-right">
                <a href="#" class="has-text-grey-light mr-4">Privacy Policy</a>
                <a href="#" class="has-text-grey-light">Terms of Service</a>
            </div>
        </div>
    </div>
</footer>