<?php
/**
 * Countdown Component
 * Countdown timer for events/launches
 * 
 * Attributes:
 * - title: Heading
 * - target_date: Target date (Y-m-d H:i:s format)
 * - background: Background color (primary, dark, light)
 * - end_message: Message when countdown ends
 */

$title = $title ?? 'Coming Soon!';
$target_date = $target_date ?? date('Y-m-d H:i:s', strtotime('+7 days'));
$background = $background ?? 'dark';
$end_message = $end_message ?? 'The event has started!';

$countdownId = 'countdown-' . uniqid();
$isLight = $background === 'light';
?>
<section class="section has-background-<?= htmlspecialchars($background) ?>">
    <div class="container">
        <h2 class="title is-2 has-text-centered <?= $isLight ? '' : 'has-text-white' ?>"><?= htmlspecialchars($title) ?>
        </h2>

        <div class="columns is-centered mt-5">
            <div class="column is-full-mobile is-10-tablet is-8-desktop">
                <div class="columns has-text-centered" id="<?= $countdownId ?>">
                    <div class="column is-6-mobile is-3-tablet">
                        <div class="box" style="background: <?= $isLight ? '#f5f5f5' : 'rgba(255,255,255,0.1)' ?>;">
                            <p class="title is-1 <?= $isLight ? '' : 'has-text-white' ?>" id="<?= $countdownId ?>-days">
                                00</p>
                            <p class="subtitle is-6 <?= $isLight ? 'has-text-grey' : 'has-text-white-ter' ?>">Days</p>
                        </div>
                    </div>
                    <div class="column is-6-mobile is-3-tablet">
                        <div class="box" style="background: <?= $isLight ? '#f5f5f5' : 'rgba(255,255,255,0.1)' ?>;">
                            <p class="title is-1 <?= $isLight ? '' : 'has-text-white' ?>"
                                id="<?= $countdownId ?>-hours">00</p>
                            <p class="subtitle is-6 <?= $isLight ? 'has-text-grey' : 'has-text-white-ter' ?>">Hours</p>
                        </div>
                    </div>
                    <div class="column is-6-mobile is-3-tablet">
                        <div class="box" style="background: <?= $isLight ? '#f5f5f5' : 'rgba(255,255,255,0.1)' ?>;">
                            <p class="title is-1 <?= $isLight ? '' : 'has-text-white' ?>"
                                id="<?= $countdownId ?>-minutes">00</p>
                            <p class="subtitle is-6 <?= $isLight ? 'has-text-grey' : 'has-text-white-ter' ?>">Minutes
                            </p>
                        </div>
                    </div>
                    <div class="column is-6-mobile is-3-tablet">
                        <div class="box" style="background: <?= $isLight ? '#f5f5f5' : 'rgba(255,255,255,0.1)' ?>;">
                            <p class="title is-1 <?= $isLight ? '' : 'has-text-white' ?>"
                                id="<?= $countdownId ?>-seconds">00</p>
                            <p class="subtitle is-6 <?= $isLight ? 'has-text-grey' : 'has-text-white-ter' ?>">Seconds
                            </p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<script>
    (function () {
        const targetDate = new Date('<?= $target_date ?>').getTime();
        const endMessage = '<?= addslashes($end_message) ?>';

        function updateCountdown() {
            const now = new Date().getTime();
            const diff = targetDate - now;

            if (diff <= 0) {
                document.getElementById('<?= $countdownId ?>').innerHTML = '<div class="column"><p class="title is-2 has-text-white">' + endMessage + '</p></div>';
                return;
            }

            const days = Math.floor(diff / (1000 * 60 * 60 * 24));
            const hours = Math.floor((diff % (1000 * 60 * 60 * 24)) / (1000 * 60 * 60));
            const minutes = Math.floor((diff % (1000 * 60 * 60)) / (1000 * 60));
            const seconds = Math.floor((diff % (1000 * 60)) / 1000);

            document.getElementById('<?= $countdownId ?>-days').textContent = String(days).padStart(2, '0');
            document.getElementById('<?= $countdownId ?>-hours').textContent = String(hours).padStart(2, '0');
            document.getElementById('<?= $countdownId ?>-minutes').textContent = String(minutes).padStart(2, '0');
            document.getElementById('<?= $countdownId ?>-seconds').textContent = String(seconds).padStart(2, '0');
        }

        updateCountdown();
        setInterval(updateCountdown, 1000);
    })();
</script>