<?php
/**
 * Breadcrumb Component
 * Page navigation breadcrumb
 * 
 * Attributes:
 * - items: JSON array with text and link
 */

$items = $items ?? [];
if (is_string($items)) {
    $items = json_decode(html_entity_decode($items), true) ?: [];
}

if (empty($items)) {
    $items = [
        ['text' => 'Home', 'link' => '/'],
        ['text' => 'Products', 'link' => '/products'],
        ['text' => 'Current Page', 'link' => '']
    ];
}
?>
<section class="section py-3">
    <div class="container">
        <nav class="breadcrumb has-arrow-separator" aria-label="breadcrumbs">
            <ul>
                <?php foreach ($items as $i => $item):
                    $isLast = $i === count($items) - 1;
                    ?>
                    <li class="<?= $isLast ? 'is-active' : '' ?>">
                        <?php if ($isLast || empty($item['link'])): ?>
                            <a href="#" aria-current="page"><?= htmlspecialchars($item['text'] ?? '') ?></a>
                        <?php else: ?>
                            <a href="<?= htmlspecialchars($item['link']) ?>"><?= htmlspecialchars($item['text'] ?? '') ?></a>
                        <?php endif; ?>
                    </li>
                <?php endforeach; ?>
            </ul>
        </nav>
    </div>
</section>