<?php
/**
 * Blank Template for Visual Builder Pages
 * This template outputs content directly without any wrapper layout.
 * Used when pages are created with the Visual Builder.
 */

// Check if content contains full HTML document
$content = $content ?? '';

// If content starts with <!DOCTYPE or <html, output as-is (full HTML document)
if (preg_match('/^\s*<!DOCTYPE|^\s*<html/i', $content)) {
    echo $content;
} else {
    // Otherwise, wrap in basic HTML structure
    ?>
    <!DOCTYPE html>
    <html lang="en">

    <head>
        <meta charset="UTF-8">
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <title><?= $this->e($title ?? 'Page') ?></title>
        <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bulma@0.9.4/css/bulma.min.css">
        <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
        <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/animate.css/4.1.1/animate.min.css">
    </head>

    <body>
        <?= $content ?>
    </body>

    </html>
    <?php
}