<?php

namespace Models;

use Core\Model;

class Page extends Model
{
    protected static $table = 'pages';

    public static function findBySlug($slug)
    {
        $stmt = self::$pdo->prepare("SELECT * FROM " . static::$table . " WHERE slug = ? AND (status = 'published' OR (status = 'scheduled' AND published_at <= datetime('now'))) LIMIT 1");
        $stmt->execute([$slug]);
        return $stmt->fetch();
    }
}
