<?php

namespace Core;

use Models\Meta;

class Theme
{
    // List of available Bulmaswatch themes
    public const THEMES = [
        'default' => 'Default (Bulma)',
        'cerulean' => 'Cerulean',
        'cosmo' => 'Cosmo',
        'cyborg' => 'Cyborg',
        'darkly' => 'Darkly',
        'flatly' => 'Flatly',
        'journal' => 'Journal',
        'litera' => 'Litera',
        'lumen' => 'Lumen',
        'lux' => 'Lux',
        'materia' => 'Materia',
        'minty' => 'Minty',
        'nuclear' => 'Nuclear',
        'pulse' => 'Pulse',
        'sandstone' => 'Sandstone',
        'simplex' => 'Simplex',
        'slate' => 'Slate',
        'solar' => 'Solar',
        'spacelab' => 'Spacelab',
        'superhero' => 'Superhero',
        'united' => 'United',
        'yeti' => 'Yeti',
    ];

    /**
     * Get the current theme slug directly from DB or default
     */
    public static function getCurrentTheme()
    {
        return Meta::get(0, 'site', 'theme_preset') ?: 'default';
    }

    /**
     * Get the CDN URL for the current theme
     */
    public static function getCssUrl()
    {
        $theme = self::getCurrentTheme();
        
        if ($theme === 'default') {
            return 'https://cdn.jsdelivr.net/npm/bulma@0.9.4/css/bulma.min.css';
        }

        return "https://cdn.jsdelivr.net/npm/bulmaswatch@0.8.1/{$theme}/bulmaswatch.min.css";
    }
}
