<?php

namespace Core;

class ComponentRegistry
{
    public static function getAvailableComponents()
    {
        $theme = 'default';
        $dir = __DIR__ . "/../../themes/{$theme}/components/";
        $components = [];

        if (is_dir($dir)) {
            $files = glob($dir . "*.php");
            foreach ($files as $file) {
                $name = basename($file, '.php');
                $components[] = [
                    'name' => $name,
                    'path' => $file,
                    'schema' => self::getComponentSchema($file)
                ];
            }
        }
        return $components;
    }

    private static function getComponentSchema($file)
    {
        // Simple logic to extract variables from the component file
        // In a real app, this could be a JSON file or docblock
        $content = file_get_contents($file);
        preg_match_all('/\$([a-zA-Z0-9_]+)/', $content, $matches);
        return array_unique($matches[1]);
    }
}
