<?php
require_once __DIR__ . '/bootstrap.php';
/**
 * Admin Settings
 */

if (!\Core\Auth::check()) {
    header('Location: /admin/login.php');
    exit;
}

$successMessage = null;

// Handle form submission
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $fields = ['site_title', 'site_description', 'site_url', 'admin_email', 'posts_per_page', 'brand_color', 'theme_preset', 'tracking_head', 'tracking_body'];

    foreach ($fields as $field) {
        if (isset($_POST[$field])) {
            \Models\Meta::set(0, 'site', $field, $_POST[$field]);
        }
    }

    \Core\Cache::clear();
    $successMessage = 'Settings saved successfully!';
}

// Helper to get meta value
function get_meta($key, $default = '')
{
    return \Models\Meta::get(0, 'site', $key) ?: $default;
}

// Page settings
$pageTitle = 'Settings';
$currentPage = 'settings';

// Start content buffer
ob_start();
?>

<div class="columns">
    <div class="column is-8">
        <form method="POST" class="admin-form">
            <input type="hidden" name="csrf_token" value="<?= \Core\Auth::generateCsrfToken() ?>">

            <!-- Site Identity -->
            <div class="admin-card">
                <h2 class="card-header-title">
                    <span class="icon mr-2"><i class="fas fa-globe"></i></span>
                    Site Identity
                </h2>

                <div class="field">
                    <label class="label">Site Title</label>
                    <div class="control has-icons-left">
                        <input class="input" type="text" name="site_title"
                            value="<?= htmlspecialchars(get_meta('site_title')) ?>" placeholder="My Website">
                        <span class="icon is-small is-left">
                            <i class="fas fa-heading"></i>
                        </span>
                    </div>
                </div>

                <div class="field">
                    <label class="label">Site Description</label>
                    <div class="control">
                        <textarea class="textarea" name="site_description" rows="3"
                            placeholder="A brief description of your website"><?= htmlspecialchars(get_meta('site_description')) ?></textarea>
                    </div>
                </div>

                <div class="field">
                    <label class="label">Site URL</label>
                    <div class="control has-icons-left">
                        <input class="input" type="url" name="site_url"
                            value="<?= htmlspecialchars(get_meta('site_url')) ?>" placeholder="https://example.com">
                        <span class="icon is-small is-left">
                            <i class="fas fa-link"></i>
                        </span>
                    </div>
                </div>
            </div>

            <!-- Appearance -->
            <div class="admin-card">
                <h2 class="card-header-title">
                    <span class="icon mr-2"><i class="fas fa-palette"></i></span>
                    Appearance
                </h2>

                <div class="field">
                    <label class="label">Theme Preset</label>
                    <div class="control">
                        <div class="select is-fullwidth">
                            <select name="theme_preset">
                                <?php foreach (\Core\Theme::THEMES as $slug => $name): ?>
                                    <option value="<?= $slug ?>" <?= get_meta('theme_preset') === $slug ? 'selected' : '' ?>>
                                        <?= $name ?>
                                    </option>
                                <?php endforeach; ?>
                            </select>
                        </div>
                    </div>
                    <p class="help">Select a Bulmaswatch theme for your site's look and feel.</p>
                </div>

                <div class="field">
                    <label class="label">Brand Color</label>
                    <div class="control">
                        <input class="input" type="color" name="brand_color"
                            value="<?= htmlspecialchars(get_meta('brand_color', '#3273dc')) ?>"
                            style="height: 50px; padding: 5px;">
                    </div>
                    <p class="help">Used for custom accents (some themes may override this).</p>
                </div>
            </div>

            <!-- SEO & Analytics -->
            <div class="admin-card">
                <h2 class="card-header-title">
                    <span class="icon mr-2"><i class="fas fa-chart-line"></i></span>
                    SEO & Analytics
                </h2>

                <div class="field">
                    <label class="label">Head Tracking Code</label>
                    <div class="control">
                        <textarea class="textarea is-family-monospace" name="tracking_head" rows="4"
                            placeholder="<!-- Google Analytics, etc. -->"><?= htmlspecialchars(get_meta('tracking_head')) ?></textarea>
                    </div>
                    <p class="help">Injected before the <code>&lt;/head&gt;</code> tag.</p>
                </div>

                <div class="field">
                    <label class="label">Body Tracking Code</label>
                    <div class="control">
                        <textarea class="textarea is-family-monospace" name="tracking_body" rows="4"
                            placeholder="<!-- Facebook Pixel, etc. -->"><?= htmlspecialchars(get_meta('tracking_body')) ?></textarea>
                    </div>
                    <p class="help">Injected immediately after the <code>&lt;body&gt;</code> tag.</p>
                </div>
            </div>

            <!-- Admin Settings -->
            <div class="admin-card">
                <h2 class="card-header-title">
                    <span class="icon mr-2"><i class="fas fa-cog"></i></span>
                    Admin Settings
                </h2>

                <div class="field">
                    <label class="label">Admin Email</label>
                    <div class="control has-icons-left">
                        <input class="input" type="email" name="admin_email"
                            value="<?= htmlspecialchars(get_meta('admin_email')) ?>" placeholder="admin@example.com">
                        <span class="icon is-small is-left">
                            <i class="fas fa-envelope"></i>
                        </span>
                    </div>
                </div>

                <div class="field">
                    <label class="label">Posts Per Page</label>
                    <div class="control">
                        <input class="input" type="number" name="posts_per_page"
                            value="<?= htmlspecialchars(get_meta('posts_per_page', '10')) ?>" min="1" max="100">
                    </div>
                </div>
            </div>

            <!-- Save Button -->
            <div class="field">
                <div class="control">
                    <button type="submit" class="button is-primary is-large">
                        <span class="icon"><i class="fas fa-save"></i></span>
                        <span>Save Settings</span>
                    </button>
                </div>
            </div>

        </form>
    </div>

    <div class="column is-4">
        <!-- Theme Preview -->
        <div class="admin-card">
            <h2 class="card-header-title">
                <span class="icon mr-2"><i class="fas fa-eye"></i></span>
                Current Theme
            </h2>
            <div class="has-text-centered p-4">
                <p class="is-size-4 has-text-weight-bold mb-2">
                    <?= ucfirst(get_meta('theme_preset', 'default')) ?>
                </p>
                <a href="/" target="_blank" class="button is-primary is-light">
                    <span class="icon"><i class="fas fa-external-link-alt"></i></span>
                    <span>Preview Site</span>
                </a>
            </div>
        </div>

        <!-- Quick Links -->
        <div class="admin-card">
            <h2 class="card-header-title">
                <span class="icon mr-2"><i class="fas fa-link"></i></span>
                Quick Links
            </h2>
            <div class="content">
                <ul>
                    <li><a href="/admin/maintenance.php">System Maintenance</a></li>
                    <li><a href="/admin/components.php">Manage Components</a></li>
                    <li><a href="/admin/media.php">Media Library</a></li>
                </ul>
            </div>
        </div>

        <!-- Info -->
        <div class="admin-card">
            <h2 class="card-header-title">
                <span class="icon mr-2"><i class="fas fa-info-circle"></i></span>
                Info
            </h2>
            <div class="content is-small">
                <p>Changes to site settings will take effect immediately. The cache is cleared automatically when you
                    save.</p>
            </div>
        </div>
    </div>
</div>

<?php
$content = ob_get_clean();
include __DIR__ . '/layouts/admin_layout.php';