<?php
/**
 * Admin Layout Template
 */

require_once __DIR__ . '/../bootstrap.php';

// Site settings
$siteTitle = \Models\Meta::get(0, 'site', 'site_title') ?: 'AI-Native CMS';
$themeUrl = \Core\Theme::getCssUrl();

// Default values
$pageTitle = $pageTitle ?? 'Admin';
$currentPage = $currentPage ?? '';
$content = $content ?? '';
$csrfToken = \Core\Auth::generateCsrfToken();
?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="csrf-token" content="<?= $csrfToken ?>">
    <title><?= htmlspecialchars($pageTitle) ?> - <?= htmlspecialchars($siteTitle) ?> Admin</title>

    <!-- Bulma CSS with Lux Theme -->
    <link rel="stylesheet" href="<?= $themeUrl ?>">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">

    <style>
        :root {
            --sidebar-width: 250px;
        }

        body {
            min-height: 100vh;
        }

        /* Sidebar */
        .admin-sidebar {
            position: fixed;
            top: 0;
            left: 0;
            width: var(--sidebar-width);
            height: 100vh;
            background: linear-gradient(180deg, #1a1a2e 0%, #16213e 100%);
            padding-top: 1rem;
            overflow-y: auto;
            z-index: 100;
        }

        .admin-sidebar .brand {
            padding: 1rem 1.5rem;
            border-bottom: 1px solid rgba(255, 255, 255, 0.1);
            margin-bottom: 1rem;
        }

        .admin-sidebar .brand a {
            color: white;
            font-size: 1.25rem;
            font-weight: 700;
            text-decoration: none;
        }

        .admin-sidebar .menu-label {
            color: rgba(255, 255, 255, 0.5);
            font-size: 0.75rem;
            text-transform: uppercase;
            letter-spacing: 0.1em;
            padding: 0.5rem 1.5rem;
            margin-top: 1rem;
        }

        .admin-sidebar .menu-list a {
            color: rgba(255, 255, 255, 0.8);
            padding: 0.75rem 1.5rem;
            display: flex;
            align-items: center;
            gap: 0.75rem;
            transition: all 0.2s;
            border-left: 3px solid transparent;
        }

        .admin-sidebar .menu-list a:hover {
            background: rgba(255, 255, 255, 0.05);
            color: white;
        }

        .admin-sidebar .menu-list a.is-active {
            background: rgba(255, 255, 255, 0.1);
            color: white;
            border-left-color: #3273dc;
        }

        .admin-sidebar .menu-list .icon {
            width: 20px;
            text-align: center;
        }

        /* Main Content */
        .admin-main {
            margin-left: var(--sidebar-width);
            min-height: 100vh;
            background: #f5f7fa;
        }

        .admin-header {
            background: white;
            padding: 1rem 2rem;
            border-bottom: 1px solid #e1e5eb;
            display: flex;
            justify-content: space-between;
            align-items: center;
            position: sticky;
            top: 0;
            z-index: 50;
        }

        .admin-header .page-title {
            font-size: 1.5rem;
            font-weight: 600;
            color: #1a1a2e;
            margin: 0;
        }

        .admin-content {
            padding: 2rem;
        }

        /* Cards */
        .admin-card {
            background: white;
            border-radius: 8px;
            box-shadow: 0 2px 4px rgba(0, 0, 0, 0.05);
            padding: 1.5rem;
            margin-bottom: 1.5rem;
        }

        .admin-card .card-header-title {
            font-size: 1.1rem;
            font-weight: 600;
            color: #1a1a2e;
            border-bottom: 1px solid #e1e5eb;
            padding-bottom: 1rem;
            margin-bottom: 1rem;
        }

        /* Stats Cards */
        .stat-card {
            background: white;
            border-radius: 8px;
            box-shadow: 0 2px 4px rgba(0, 0, 0, 0.05);
            padding: 1.5rem;
            display: flex;
            align-items: center;
            gap: 1rem;
        }

        .stat-card .stat-icon {
            width: 60px;
            height: 60px;
            border-radius: 12px;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 1.5rem;
            color: white;
        }

        .stat-card .stat-icon.is-primary {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        }

        .stat-card .stat-icon.is-success {
            background: linear-gradient(135deg, #11998e 0%, #38ef7d 100%);
        }

        .stat-card .stat-icon.is-warning {
            background: linear-gradient(135deg, #f093fb 0%, #f5576c 100%);
        }

        .stat-card .stat-icon.is-info {
            background: linear-gradient(135deg, #4facfe 0%, #00f2fe 100%);
        }

        .stat-card .stat-content .stat-value {
            font-size: 1.75rem;
            font-weight: 700;
            color: #1a1a2e;
        }

        .stat-card .stat-content .stat-label {
            color: #6c757d;
            font-size: 0.875rem;
        }

        /* Table Styles */
        .table-container {
            background: white;
            border-radius: 8px;
            overflow: hidden;
        }

        .admin-table {
            width: 100%;
            margin: 0;
        }

        .admin-table th {
            background: #f8f9fa;
            font-weight: 600;
            color: #1a1a2e;
            border-bottom: 2px solid #e1e5eb;
        }

        .admin-table td {
            vertical-align: middle;
        }

        .admin-table tbody tr:hover {
            background: #f8f9fa;
        }

        /* Form Styles */
        .admin-form .field {
            margin-bottom: 1.25rem;
        }

        .admin-form .label {
            font-weight: 600;
            color: #1a1a2e;
        }

        /* Action Buttons */
        .action-buttons {
            display: flex;
            gap: 0.5rem;
        }

        /* Quick Actions */
        .quick-actions {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(150px, 1fr));
            gap: 1rem;
        }

        .quick-action-card {
            background: white;
            border-radius: 8px;
            padding: 1.5rem;
            text-align: center;
            transition: all 0.2s;
            text-decoration: none;
            color: inherit;
            border: 2px solid transparent;
        }

        .quick-action-card:hover {
            transform: translateY(-2px);
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1);
            border-color: #3273dc;
        }

        .quick-action-card .icon {
            font-size: 2rem;
            margin-bottom: 0.5rem;
            color: #3273dc;
        }

        .quick-action-card .title {
            font-size: 0.9rem;
            font-weight: 600;
            color: #1a1a2e;
        }

        /* Status Badges */
        .status-badge {
            display: inline-flex;
            align-items: center;
            padding: 0.25rem 0.75rem;
            border-radius: 20px;
            font-size: 0.75rem;
            font-weight: 600;
            text-transform: uppercase;
        }

        .status-badge.is-published {
            background: #d4edda;
            color: #155724;
        }

        .status-badge.is-draft {
            background: #fff3cd;
            color: #856404;
        }

        /* Mobile Responsive */
        @media (max-width: 1024px) {
            .admin-sidebar {
                transform: translateX(-100%);
                transition: transform 0.3s;
            }

            .admin-sidebar.is-active {
                transform: translateX(0);
            }

            .admin-main {
                margin-left: 0;
            }
        }
    </style>
</head>

<body>
    <!-- Sidebar -->
    <aside class="admin-sidebar">
        <div class="brand">
            <a href="/">
                <i class="fas fa-cube"></i> <?= htmlspecialchars($siteTitle) ?>
            </a>
        </div>

        <p class="menu-label">Main</p>
        <ul class="menu-list">
            <li>
                <a href="/admin/" class="<?= $currentPage === 'dashboard' ? 'is-active' : '' ?>">
                    <span class="icon"><i class="fas fa-tachometer-alt"></i></span>
                    Dashboard
                </a>
            </li>
            <li>
                <a href="/admin/pages.php" class="<?= $currentPage === 'pages' ? 'is-active' : '' ?>">
                    <span class="icon"><i class="fas fa-file-alt"></i></span>
                    Pages
                </a>
            </li>
            <li>
                <a href="/admin/page-builder.php" class="<?= $currentPage === 'page-builder' ? 'is-active' : '' ?>">
                    <span class="icon"><i class="fas fa-columns"></i></span>
                    Page Builder
                </a>
            </li>
            <li>
                <a href="/admin/posts.php" class="<?= $currentPage === 'posts' ? 'is-active' : '' ?>">
                    <span class="icon"><i class="fas fa-blog"></i></span>
                    Posts
                </a>
            </li>
        </ul>

        <p class="menu-label">Post Types</p>
        <ul class="menu-list">
            <li>
                <a href="/admin/post-types.php" class="<?= $currentPage === 'post-types' ? 'is-active' : '' ?>">
                    <span class="icon"><i class="fas fa-cubes"></i></span>
                    Manage Types
                </a>
            </li>
            <?php
            // Dynamic post type menu items
            try {
                if (!class_exists('\Models\PostType')) {
                    require_once __DIR__ . '/../../../src/Models/PostType.php';
                }
                if (!defined('DB_PATH')) {
                    $tenantId = \Core\MultiTenancy::getTenantId();
                    define('DB_PATH', \Core\MultiTenancy::getDatabasePath($tenantId));
                }
                $ptPdo = new PDO('sqlite:' . DB_PATH);
                $ptPdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
                \Models\PostType::setPdo($ptPdo);
                $menuPostTypes = \Models\PostType::all();
                foreach ($menuPostTypes as $mpt):
                    ?>
                    <li>
                        <a href="/admin/custom-posts.php?type=<?= $mpt['name'] ?>"
                            class="<?= $currentPage === 'post-type-' . $mpt['name'] ? 'is-active' : '' ?>">
                            <span class="icon"><i class="<?= htmlspecialchars($mpt['icon']) ?>"></i></span>
                            <?= htmlspecialchars($mpt['label_plural']) ?>
                        </a>
                    </li>
                    <?php
                endforeach;
            } catch (Exception $e) {
                // Silently fail if tables don't exist yet
            }
            ?>
        </ul>

        <p class="menu-label">Content</p>
        <ul class="menu-list">
            <li>
                <a href="/admin/components.php" class="<?= $currentPage === 'components' ? 'is-active' : '' ?>">
                    <span class="icon"><i class="fas fa-puzzle-piece"></i></span>
                    Components
                </a>
            </li>
            <li>
                <a href="/admin/component-config.php"
                    class="<?= $currentPage === 'component-config' ? 'is-active' : '' ?>">
                    <span class="icon"><i class="fas fa-sliders-h"></i></span>
                    Component Builder
                </a>
            </li>
            <li>
                <a href="/admin/media.php" class="<?= $currentPage === 'media' ? 'is-active' : '' ?>">
                    <span class="icon"><i class="fas fa-images"></i></span>
                    Media
                </a>
            </li>
        </ul>

        <p class="menu-label">System</p>
        <ul class="menu-list">
            <li>
                <a href="/admin/settings.php" class="<?= $currentPage === 'settings' ? 'is-active' : '' ?>">
                    <span class="icon"><i class="fas fa-cog"></i></span>
                    Settings
                </a>
            </li>
            <li>
                <a href="/admin/maintenance.php" class="<?= $currentPage === 'maintenance' ? 'is-active' : '' ?>">
                    <span class="icon"><i class="fas fa-tools"></i></span>
                    Maintenance
                </a>
            </li>
            <li>
                <a href="/admin/playground.php" class="<?= $currentPage === 'playground' ? 'is-active' : '' ?>">
                    <span class="icon"><i class="fas fa-flask"></i></span>
                    Playground
                </a>
            </li>
        </ul>

        <p class="menu-label">Account</p>
        <ul class="menu-list">
            <li>
                <a href="/" target="_blank">
                    <span class="icon"><i class="fas fa-external-link-alt"></i></span>
                    View Site
                </a>
            </li>
            <li>
                <a href="/admin/logout.php">
                    <span class="icon"><i class="fas fa-sign-out-alt"></i></span>
                    Logout
                </a>
            </li>
        </ul>
    </aside>

    <!-- Main Content -->
    <div class="admin-main">
        <!-- Header -->
        <header class="admin-header">
            <h1 class="page-title"><?= htmlspecialchars($pageTitle) ?></h1>
            <div class="header-actions">
                <?php if (isset($headerActions)): ?>
                    <?= $headerActions ?>
                <?php endif; ?>
            </div>
        </header>

        <!-- Content -->
        <main class="admin-content">
            <?php if (isset($successMessage)): ?>
                <div class="notification is-success is-light">
                    <button class="delete"></button>
                    <?= $successMessage ?>
                </div>
            <?php endif; ?>

            <?php if (isset($errorMessage)): ?>
                <div class="notification is-danger is-light">
                    <button class="delete"></button>
                    <?= $errorMessage ?>
                </div>
            <?php endif; ?>

            <?= $content ?>
        </main>
    </div>

    <script>
        // Notification close
        document.querySelectorAll('.notification .delete').forEach(btn => {
            btn.addEventListener('click', () => {
                btn.parentElement.remove();
            });
        });

        // Mobile menu toggle
        const menuToggle = document.querySelector('.menu-toggle');
        const sidebar = document.querySelector('.admin-sidebar');
        if (menuToggle) {
            menuToggle.addEventListener('click', () => {
                sidebar.classList.toggle('is-active');
            });
        }
    </script>
</body>

</html>