<?php
/**
 * Related Posts Component
 * Display related/latest blog posts
 * 
 * Attributes:
 * - title: Section title
 * - posts: JSON array with title, excerpt, image, date, link
 * - columns: Number of posts to show (2, 3, 4)
 */

$sectionTitle = $title ?? 'Related Posts';
$columns = $columns ?? 3;
$posts = $posts ?? [];

if (is_string($posts)) {
    $posts = json_decode(html_entity_decode($posts), true) ?: [];
}

if (empty($posts)) {
    $posts = [
        ['title' => 'Getting Started with Our Platform', 'excerpt' => 'Learn how to get started with our platform in just a few simple steps.', 'image' => 'https://picsum.photos/400/250?random=40', 'date' => 'Jan 10, 2024', 'link' => '#'],
        ['title' => 'Top 10 Tips for Success', 'excerpt' => 'Discover the top strategies that will help you achieve your goals.', 'image' => 'https://picsum.photos/400/250?random=41', 'date' => 'Jan 8, 2024', 'link' => '#'],
        ['title' => 'Industry Trends to Watch', 'excerpt' => 'Stay ahead of the curve with these emerging industry trends.', 'image' => 'https://picsum.photos/400/250?random=42', 'date' => 'Jan 5, 2024', 'link' => '#']
    ];
}

$colClass = match ((int) $columns) {
    2 => 'is-6',
    4 => 'is-3',
    default => 'is-4'
};
?>
<section class="section has-background-light">
    <div class="container">
        <h2 class="title is-3 mb-5"><?= htmlspecialchars($sectionTitle) ?></h2>

        <div class="columns">
            <?php foreach (array_slice($posts, 0, $columns) as $post): ?>
                <div class="column <?= $colClass ?>">
                    <div class="card related-post-card" style="height: 100%;">
                        <div class="card-image">
                            <figure class="image is-16by9">
                                <img src="<?= htmlspecialchars($post['image'] ?? '') ?>"
                                    alt="<?= htmlspecialchars($post['title'] ?? '') ?>" style="object-fit: cover;">
                            </figure>
                        </div>
                        <div class="card-content">
                            <p class="is-size-7 has-text-grey mb-2">
                                <span class="icon is-small"><i class="fas fa-calendar"></i></span>
                                <?= htmlspecialchars($post['date'] ?? '') ?>
                            </p>
                            <p class="title is-5">
                                <a href="<?= htmlspecialchars($post['link'] ?? '#') ?>" class="has-text-dark">
                                    <?= htmlspecialchars($post['title'] ?? '') ?>
                                </a>
                            </p>
                            <p class="content is-size-7"><?= htmlspecialchars($post['excerpt'] ?? '') ?></p>
                        </div>
                    </div>
                </div>
            <?php endforeach; ?>
        </div>
    </div>
</section>

<style>
    .related-post-card {
        transition: transform 0.3s, box-shadow 0.3s;
    }

    .related-post-card:hover {
        transform: translateY(-5px);
        box-shadow: 0 10px 20px rgba(0, 0, 0, 0.1);
    }
</style>