<?php
/**
 * Progress Bar Component
 * Display progress indicators
 * 
 * Attributes:
 * - title: Section title
 * - items: JSON array with label, value (0-100), color (primary, success, warning, danger)
 */

$sectionTitle = $title ?? '';
$items = $items ?? [];

if (is_string($items)) {
    $items = json_decode(html_entity_decode($items), true) ?: [];
}

if (empty($items)) {
    $items = [
        ['label' => 'Web Development', 'value' => 90, 'color' => 'primary'],
        ['label' => 'Mobile Apps', 'value' => 85, 'color' => 'success'],
        ['label' => 'UI/UX Design', 'value' => 80, 'color' => 'info'],
        ['label' => 'Cloud Services', 'value' => 75, 'color' => 'warning']
    ];
}
?>
<section class="section">
    <div class="container">
        <?php if ($sectionTitle): ?>
            <h2 class="title is-3 has-text-centered mb-6"><?= htmlspecialchars($sectionTitle) ?></h2>
        <?php endif; ?>

        <div class="columns is-centered">
            <div class="column is-8">
                <?php foreach ($items as $item): ?>
                    <div class="mb-5">
                        <div class="level is-mobile mb-2">
                            <div class="level-left">
                                <span class="has-text-weight-semibold"><?= htmlspecialchars($item['label'] ?? '') ?></span>
                            </div>
                            <div class="level-right">
                                <span class="has-text-grey"><?= (int) ($item['value'] ?? 0) ?>%</span>
                            </div>
                        </div>
                        <progress class="progress is-<?= htmlspecialchars($item['color'] ?? 'primary') ?>"
                            value="<?= (int) ($item['value'] ?? 0) ?>" max="100">
                            <?= (int) ($item['value'] ?? 0) ?>%
                        </progress>
                    </div>
                <?php endforeach; ?>
            </div>
        </div>
    </div>
</section>