<?php
/**
 * Modal Component
 * Popup modal dialog
 * 
 * Attributes:
 * - id: Unique modal ID
 * - title: Modal title
 * - content: Modal body content (HTML)
 * - trigger_text: Button text to open modal
 * - trigger_class: Button class (primary, info, etc.)
 * - show_footer: Show cancel/confirm buttons
 */

$modalId = $id ?? 'modal-' . uniqid();
$title = $title ?? 'Modal Title';
$content = $content ?? '<p>This is the modal content. You can add any HTML here.</p>';
$trigger_text = $trigger_text ?? 'Open Modal';
$trigger_class = $trigger_class ?? 'primary';
$show_footer = $show_footer ?? true;
?>

<button class="button is-<?= htmlspecialchars($trigger_class) ?>"
    onclick="document.getElementById('<?= $modalId ?>').classList.add('is-active')">
    <?= htmlspecialchars($trigger_text) ?>
</button>

<div class="modal" id="<?= $modalId ?>">
    <div class="modal-background" onclick="this.parentElement.classList.remove('is-active')"></div>
    <div class="modal-card">
        <header class="modal-card-head">
            <p class="modal-card-title"><?= htmlspecialchars($title) ?></p>
            <button class="delete" aria-label="close"
                onclick="this.closest('.modal').classList.remove('is-active')"></button>
        </header>
        <section class="modal-card-body">
            <?= $content ?>
        </section>
        <?php if ($show_footer): ?>
            <footer class="modal-card-foot">
                <button class="button is-success"
                    onclick="this.closest('.modal').classList.remove('is-active')">Confirm</button>
                <button class="button" onclick="this.closest('.modal').classList.remove('is-active')">Cancel</button>
            </footer>
        <?php endif; ?>
    </div>
</div>