<?php
/**
 * Gallery Component
 * Image gallery grid with lightbox
 * 
 * Attributes:
 * - title: Section title
 * - images: JSON array with src, alt, caption
 */

$sectionTitle = $title ?? 'Gallery';
$images = $images ?? [];

if (is_string($images)) {
    $decoded = json_decode(html_entity_decode($images), true);
    $images = is_array($decoded) ? $decoded : [];
}

if (empty($images)) {
    $images = [
        ['src' => 'https://picsum.photos/400/300?random=1', 'alt' => 'Image 1', 'caption' => 'Project Alpha'],
        ['src' => 'https://picsum.photos/400/300?random=2', 'alt' => 'Image 2', 'caption' => 'Project Beta'],
        ['src' => 'https://picsum.photos/400/300?random=3', 'alt' => 'Image 3', 'caption' => 'Project Gamma'],
        ['src' => 'https://picsum.photos/400/300?random=4', 'alt' => 'Image 4', 'caption' => 'Project Delta'],
        ['src' => 'https://picsum.photos/400/300?random=5', 'alt' => 'Image 5', 'caption' => 'Project Epsilon'],
        ['src' => 'https://picsum.photos/400/300?random=6', 'alt' => 'Image 6', 'caption' => 'Project Zeta']
    ];
}
?>
<section class="section">
    <div class="container">
        <h2 class="title is-2 has-text-centered mb-6"><?= htmlspecialchars($sectionTitle) ?></h2>

        <div class="columns is-multiline">
            <?php foreach ($images as $img): ?>
                <div class="column is-full-mobile is-6-tablet is-4-desktop">
                    <div class="card gallery-card">
                        <div class="card-image">
                            <figure class="image is-4by3">
                                <img src="<?= htmlspecialchars($img['src'] ?? '') ?>"
                                    alt="<?= htmlspecialchars($img['alt'] ?? '') ?>" style="object-fit: cover;">
                            </figure>
                        </div>
                        <?php if (!empty($img['caption'])): ?>
                            <div class="card-content p-3">
                                <p class="has-text-centered has-text-weight-semibold">
                                    <?= htmlspecialchars($img['caption']) ?>
                                </p>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            <?php endforeach; ?>
        </div>
    </div>
</section>

<style>
    .gallery-card {
        transition: transform 0.3s, box-shadow 0.3s;
    }

    .gallery-card:hover {
        transform: translateY(-5px);
        box-shadow: 0 10px 30px rgba(0, 0, 0, 0.15);
    }
</style>