<?php
// Handle items - could be array or JSON string
$featureItems = $items ?? [];
if (is_string($featureItems)) {
    $decoded = json_decode(html_entity_decode($featureItems), true);
    $featureItems = is_array($decoded) ? $decoded : [];
}
$sectionTitle = $title ?? 'Features';
$sectionDescription = $description ?? '';
?>
<section class="section">
    <div class="container">
        <?php if ($sectionTitle): ?>
            <div class="has-text-centered mb-6">
                <h2 class="title is-2"><?= htmlspecialchars($sectionTitle) ?></h2>
                <?php if ($sectionDescription): ?>
                    <p class="subtitle is-5"><?= htmlspecialchars($sectionDescription) ?></p>
                <?php endif; ?>
            </div>
        <?php endif; ?>

        <div class="columns is-multiline is-centered">
            <?php foreach ($featureItems as $item): ?>
                <div class="column is-full-mobile is-4-tablet">
                    <div class="box" style="height: 100%;">
                        <h3 class="title is-4"><?= htmlspecialchars($item['title'] ?? '') ?></h3>
                        <div class="content">
                            <?= htmlspecialchars($item['description'] ?? '') ?>
                        </div>
                    </div>
                </div>
            <?php endforeach; ?>
        </div>
    </div>
</section>