<?php
/**
 * Feature List Component
 * List with check icons
 * 
 * Attributes:
 * - title: Section title
 * - subtitle: Section subtitle
 * - features: JSON array of feature strings
 * - icon: Icon class (default: fa-check)
 * - icon_color: Icon color (success, primary, info)
 */

$sectionTitle = $title ?? '';
$subtitle = $subtitle ?? '';
$features = $features ?? [];
$icon = $icon ?? 'fa-check';
$icon_color = $icon_color ?? 'success';

if (is_string($features)) {
    $features = json_decode(html_entity_decode($features), true) ?: [];
}

if (empty($features)) {
    $features = [
        'Free 14-day trial with no credit card required',
        'Unlimited users on all plans',
        '24/7 customer support via email and chat',
        'Advanced analytics and reporting',
        'Integration with 100+ popular tools',
        'Enterprise-grade security and compliance',
        'Regular updates and new features',
        'Cancel anytime, no questions asked'
    ];
}
?>
<section class="section">
    <div class="container">
        <?php if ($sectionTitle || $subtitle): ?>
            <div class="has-text-centered mb-6">
                <?php if ($sectionTitle): ?>
                    <h2 class="title is-2"><?= htmlspecialchars($sectionTitle) ?></h2>
                <?php endif; ?>
                <?php if ($subtitle): ?>
                    <p class="subtitle is-5"><?= htmlspecialchars($subtitle) ?></p>
                <?php endif; ?>
            </div>
        <?php endif; ?>

        <div class="columns is-centered">
            <div class="column is-8">
                <div class="columns is-multiline">
                    <?php foreach ($features as $feature): ?>
                        <div class="column is-6">
                            <div class="is-flex is-align-items-center mb-3">
                                <span class="icon has-text-<?= htmlspecialchars($icon_color) ?> mr-3">
                                    <i class="fas <?= htmlspecialchars($icon) ?> fa-lg"></i>
                                </span>
                                <span><?= htmlspecialchars($feature) ?></span>
                            </div>
                        </div>
                    <?php endforeach; ?>
                </div>
            </div>
        </div>
    </div>
</section>