<?php
/**
 * CTA Banner Component
 * Full-width call-to-action banner
 * 
 * Attributes:
 * - title: Main heading
 * - subtitle: Description text
 * - cta_text: Button text
 * - cta_link: Button URL
 * - background: Background color class (primary, info, success, warning, danger, dark)
 */

$title = $title ?? 'Ready to Get Started?';
$subtitle = $subtitle ?? 'Join thousands of satisfied customers today.';
$cta_text = $cta_text ?? 'Get Started Now';
$cta_link = $cta_link ?? '#';
$background = $background ?? 'primary';
?>
<section class="section has-background-<?= htmlspecialchars($background) ?>">
    <div class="container">
        <div class="columns is-vcentered">
            <div class="column is-full-mobile is-8-tablet">
                <h2 class="title is-2 has-text-white"><?= htmlspecialchars($title) ?></h2>
                <p class="subtitle is-4 has-text-white-ter"><?= htmlspecialchars($subtitle) ?></p>
            </div>
            <div class="column is-full-mobile is-4-tablet has-text-right-tablet has-text-centered-mobile">
                <a href="<?= htmlspecialchars($cta_link) ?>" class="button is-white is-large">
                    <span><?= htmlspecialchars($cta_text) ?></span>
                    <span class="icon"><i class="fas fa-arrow-right"></i></span>
                </a>
            </div>
        </div>
    </div>
</section>