<?php
/**
 * Comparison Table Component
 * Feature comparison table
 * 
 * Attributes:
 * - title: Section title
 * - features: JSON array of feature names
 * - plans: JSON array with name and values (boolean or string)
 */

$sectionTitle = $title ?? 'Compare Plans';
$features = $features ?? [];
$plans = $plans ?? [];

if (is_string($features)) {
    $features = json_decode(html_entity_decode($features), true) ?: [];
}
if (is_string($plans)) {
    $plans = json_decode(html_entity_decode($plans), true) ?: [];
}

if (empty($features) || empty($plans)) {
    $features = ['Users', 'Storage', 'Email Support', 'Phone Support', 'API Access', 'Custom Domain', 'Analytics', 'Priority Support'];
    $plans = [
        ['name' => 'Basic', 'price' => '$9/mo', 'values' => ['5', '10GB', true, false, false, false, true, false]],
        ['name' => 'Pro', 'price' => '$29/mo', 'values' => ['25', '100GB', true, true, true, true, true, false], 'featured' => true],
        ['name' => 'Enterprise', 'price' => '$99/mo', 'values' => ['Unlimited', '1TB', true, true, true, true, true, true]]
    ];
}
?>
<section class="section">
    <div class="container">
        <h2 class="title is-2 has-text-centered mb-6"><?= htmlspecialchars($sectionTitle) ?></h2>

        <div class="table-container">
            <table class="table is-fullwidth is-hoverable">
                <thead>
                    <tr>
                        <th>Features</th>
                        <?php foreach ($plans as $plan): ?>
                            <th
                                class="has-text-centered <?= !empty($plan['featured']) ? 'has-background-primary-light' : '' ?>">
                                <p class="title is-5"><?= htmlspecialchars($plan['name'] ?? '') ?></p>
                                <p class="subtitle is-6 has-text-grey"><?= htmlspecialchars($plan['price'] ?? '') ?></p>
                            </th>
                        <?php endforeach; ?>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($features as $i => $feature): ?>
                        <tr>
                            <td><?= htmlspecialchars($feature) ?></td>
                            <?php foreach ($plans as $plan):
                                $value = $plan['values'][$i] ?? false;
                                ?>
                                <td
                                    class="has-text-centered <?= !empty($plan['featured']) ? 'has-background-primary-light' : '' ?>">
                                    <?php if ($value === true): ?>
                                        <span class="icon has-text-success"><i class="fas fa-check-circle"></i></span>
                                    <?php elseif ($value === false): ?>
                                        <span class="icon has-text-grey-light"><i class="fas fa-times-circle"></i></span>
                                    <?php else: ?>
                                        <strong><?= htmlspecialchars($value) ?></strong>
                                    <?php endif; ?>
                                </td>
                            <?php endforeach; ?>
                        </tr>
                    <?php endforeach; ?>
                </tbody>
                <tfoot>
                    <tr>
                        <td></td>
                        <?php foreach ($plans as $plan): ?>
                            <td
                                class="has-text-centered <?= !empty($plan['featured']) ? 'has-background-primary-light' : '' ?>">
                                <a href="#"
                                    class="button <?= !empty($plan['featured']) ? 'is-primary' : 'is-primary is-light' ?>">
                                    Choose Plan
                                </a>
                            </td>
                        <?php endforeach; ?>
                    </tr>
                </tfoot>
            </table>
        </div>
    </div>
</section>