<?php
/**
 * Notification/Alert Component
 * Display alerts and notifications
 * 
 * Attributes:
 * - type: primary, info, success, warning, danger
 * - title: Alert title
 * - message: Alert message
 * - dismissible: true/false
 */

$type = $type ?? 'info';
$title = $title ?? '';
$message = $message ?? 'This is an important notification.';
$dismissible = $dismissible ?? true;
?>
<section class="section py-4">
    <div class="container">
        <div class="notification is-<?= htmlspecialchars($type) ?> is-light">
            <?php if ($dismissible): ?>
                <button class="delete"></button>
            <?php endif; ?>
            <?php if ($title): ?>
                <strong><?= htmlspecialchars($title) ?></strong><br>
            <?php endif; ?>
            <?= htmlspecialchars($message) ?>
        </div>
    </div>
</section>

<?php if ($dismissible): ?>
    <script>
        document.querySelectorAll('.notification .delete').forEach(btn => {
            btn.addEventListener('click', () => btn.parentElement.remove());
        });
    </script>
<?php endif; ?>