<?php

namespace Core;

use Models\Page;

class Sitemap
{
    public static function generate()
    {
        $pages = Page::all();
        $xml = '<?xml version="1.0" encoding="UTF-8"?>';
        $xml .= '<urlset xmlns="http://www.sitemaps.org/schemas/sitemap/0.9">';
        
        foreach ($pages as $page) {
            if ($page['status'] === 'published') {
                $url = 'https://' . $_SERVER['HTTP_HOST'] . '/' . ($page['slug'] === 'home' ? '' : $page['slug']);
                $xml .= '<url>';
                $xml .= '<loc>' . htmlspecialchars($url) . '</loc>';
                $xml .= '<lastmod>' . date('Y-m-d', strtotime($page['updated_at'])) . '</lastmod>';
                $xml .= '</url>';
            }
        }
        
        $xml .= '</urlset>';
        return $xml;
    }
}
