<?php

namespace Core;

class Search
{
    public static function query($term, $pdo)
    {
        // Simple weighted search using SQL
        $sql = "SELECT *, 
                ((CASE WHEN title LIKE :term_exact THEN 10 ELSE 0 END) + 
                 (CASE WHEN title LIKE :term_part THEN 5 ELSE 0 END) + 
                 (CASE WHEN content LIKE :term_part THEN 2 ELSE 0 END)) as weight
                FROM pages 
                WHERE (title LIKE :term_part OR content LIKE :term_part) AND status = 'published'
                ORDER BY weight DESC";
        
        $stmt = $pdo->prepare($sql);
        $stmt->execute([
            'term_exact' => $term,
            'term_part' => '%' . $term . '%'
        ]);
        return $stmt->fetchAll();
    }
}
