<?php

namespace Core;

use Models\Meta;

class SEO
{
    public static function getMetaTags($objectId, $objectType, $defaultTitle)
    {
        $title = Meta::get($objectId, $objectType, 'seo_title') ?: $defaultTitle;
        $description = Meta::get($objectId, $objectType, 'seo_description');
        $ogImage = Meta::get($objectId, $objectType, 'og_image');

        $html = "<title>" . htmlspecialchars($title) . "</title>\n";
        if ($description) {
            $html .= "    <meta name=\"description\" content=\"" . htmlspecialchars($description) . "\">\n";
            $html .= "    <meta property=\"og:description\" content=\"" . htmlspecialchars($description) . "\">\n";
        }
        $html .= "    <meta property=\"og:title\" content=\"" . htmlspecialchars($title) . "\">\n";
        if ($ogImage) {
            $html .= "    <meta property=\"og:image\" content=\"" . htmlspecialchars($ogImage) . "\">\n";
        }

        return $html;
    }

    public static function getSchemaOrg($objectId, $objectType, $data)
    {
        $schema = [
            "@context" => "https://schema.org",
            "@type" => $objectType === 'post' ? "BlogPosting" : "WebPage",
            "headline" => $data['title'],
            "datePublished" => $data['created_at'],
            "dateModified" => $data['updated_at'],
        ];

        return "<script type=\"application/ld+json\">" . json_encode($schema) . "</script>";
    }
}
