<?php

namespace Core;

use Models\Meta;

class Robots
{
    public static function generate()
    {
        $siteUrl = Meta::get(0, 'site', 'site_url') ?: ('https://' . ($_SERVER['HTTP_HOST'] ?? 'localhost'));

        $output = "User-agent: *\n";
        $output .= "Allow: /\n";
        $output .= "Disallow: /admin/\n";
        $output .= "Disallow: /api/\n";
        $output .= "\n";
        $output .= "Sitemap: " . rtrim($siteUrl, '/') . "/sitemap.xml\n";

        return $output;
    }
}
