<?php
require_once __DIR__ . "/../../src/Core/Auth.php";
require_once __DIR__ . "/../../src/Core/Model.php";
require_once __DIR__ . "/../../src/Models/Page.php";
require_once __DIR__ . "/../../src/Core/SSG.php";
require_once __DIR__ . "/../../src/Core/MultiTenancy.php";

if (!\Core\Auth::check()) {
    header('Location: /admin/login.php');
    exit;
}

$tenantId = \Core\MultiTenancy::getTenantId();
define('DB_PATH', \Core\MultiTenancy::getDatabasePath($tenantId));
$pdo = new PDO('sqlite:' . DB_PATH);
\Core\Model::setPdo($pdo);

$message = '';
if (isset($_POST['action']) && $_POST['action'] === 'generate') {
    $baseUrl = 'http://' . $_SERVER['HTTP_HOST'];
    $dir = \Core\SSG::generate($baseUrl);
    $message = "Static site generated in <code>$dir</code>. You can now download these files for CDN deployment.";
}
?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Static Site Generator - AI-Native CMS</title>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/@picocss/pico@1/css/pico.min.css">
    <style>
        body {
            padding: 1rem;
        }

        .container {
            max-width: 800px;
            margin: 0 auto;
        }
    </style>
</head>

<body>
    <div class="container">
        <h1>Static Site Generator (SSG)</h1>
        <a href="/admin/" role="button">← Back to Dashboard</a>

        <p>Convert your dynamic CMS into lightning-fast static HTML files. Perfect for hosting on Cloudflare Pages,
            Netlify, or GitHub Pages.</p>

        <?php if ($message): ?><ins><?= $message ?></ins><?php endif; ?>

        <form method="POST">
            <input type="hidden" name="action" value="generate">
            <button type="submit">Generate Static Site</button>
        </form>
    </div>
</body>

</html>