<?php
require_once __DIR__ . "/../../src/Core/Auth.php";
require_once __DIR__ . "/../../src/Core/ComponentRegistry.php";
require_once __DIR__ . "/../../src/Core/Theme.php";

if (!\Core\Auth::check()) {
    header('Location: /admin/login.php');
    exit;
}

$components = \Core\ComponentRegistry::getAvailableComponents();
$prompt = "You are an AI developer for the AI-Native CMS. 
The CMS uses Bulma CSS for styling and a 'Component Contract' system.
Available components and their required data: \n\n";

foreach ($components as $comp) {
    if (isset($comp['name'])) {
        $prompt .= "- Component: {$comp['name']}\n";
        $prompt .= "  Variables: " . implode(', ', $comp['schema'] ?? []) . "\n\n";
    }
}

$prompt .= "When creating new components, follow these rules:
1. Use standard HTML5 semantic tags.
2. Use Bulma CSS classes for styling (e.g., <section class=\"section\">, <div class=\"container\">, <div class=\"columns\">).
3. Ensure the PHP code expects the variables listed above.
4. Keep the code clean and portable for shared hosting.
5. Do not use external JavaScript frameworks.
6. For images, use the variable name directly in the src attribute, assuming it's a path.";

?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>AI Prompt Generator - AI-Native CMS</title>
    <link rel="stylesheet" href="<?= \Core\Theme::getCssUrl() ?>">
    <style>
        body {
            padding: 1rem;
        }

        .container {
            max-width: 800px;
            margin: 0 auto;
        }

        textarea {
            width: 100%;
            height: 300px;
            font-family: monospace;
        }
    </style>
</head>

<body>
    <div class="container">
        <h1 class="title">AI Prompt Generator</h1>
        <a href="/admin/" class="button is-small">← Back to Dashboard</a>

        <div class="content mt-4">
            <p>Copy the prompt below to use with ChatGPT or Claude to generate new components or content for this CMS.
            </p>
        </div>

        <textarea class="textarea" readonly><?= htmlspecialchars($prompt) ?></textarea>

        <button class="button is-primary mt-4"
            onclick="navigator.clipboard.writeText(this.previousElementSibling.value); alert('Copied!')">Copy to
            Clipboard</button>
    </div>
</body>

</html>