<?php
/**
 * Admin Dashboard
 */
require_once __DIR__ . "/../../src/Core/Auth.php";
require_once __DIR__ . "/../../src/Core/Model.php";
require_once __DIR__ . "/../../src/Core/MultiTenancy.php";
require_once __DIR__ . "/../../src/Models/Page.php";
require_once __DIR__ . "/../../src/Models/Media.php";
require_once __DIR__ . "/../../src/Models/Meta.php";

// Auth check
if (!\Core\Auth::check()) {
    header('Location: /admin/login.php');
    exit;
}

// Database connection
$tenantId = \Core\MultiTenancy::getTenantId();
define('DB_PATH', \Core\MultiTenancy::getDatabasePath($tenantId));
try {
    $pdo = new PDO('sqlite:' . DB_PATH);
    \Core\Model::setPdo($pdo);
} catch (Exception $e) {
    die('DB Error: ' . $e->getMessage());
}

// Get stats
$pageCount = count(\Models\Page::all());
$mediaCount = count(\Models\Media::all());
$publishedPages = count(array_filter(\Models\Page::all(), fn($p) => $p['status'] === 'published'));
$draftPages = $pageCount - $publishedPages;

// Page settings
$pageTitle = 'Dashboard';
$currentPage = 'dashboard';

// Start content buffer
ob_start();
?>

<!-- Stats Row -->
<div class="columns">
    <div class="column is-3">
        <div class="stat-card">
            <div class="stat-icon is-primary">
                <i class="fas fa-file-alt"></i>
            </div>
            <div class="stat-content">
                <div class="stat-value"><?= $pageCount ?></div>
                <div class="stat-label">Total Pages</div>
            </div>
        </div>
    </div>
    <div class="column is-3">
        <div class="stat-card">
            <div class="stat-icon is-success">
                <i class="fas fa-check-circle"></i>
            </div>
            <div class="stat-content">
                <div class="stat-value"><?= $publishedPages ?></div>
                <div class="stat-label">Published</div>
            </div>
        </div>
    </div>
    <div class="column is-3">
        <div class="stat-card">
            <div class="stat-icon is-warning">
                <i class="fas fa-edit"></i>
            </div>
            <div class="stat-content">
                <div class="stat-value"><?= $draftPages ?></div>
                <div class="stat-label">Drafts</div>
            </div>
        </div>
    </div>
    <div class="column is-3">
        <div class="stat-card">
            <div class="stat-icon is-info">
                <i class="fas fa-images"></i>
            </div>
            <div class="stat-content">
                <div class="stat-value"><?= $mediaCount ?></div>
                <div class="stat-label">Media Files</div>
            </div>
        </div>
    </div>
</div>

<!-- Quick Actions -->
<div class="admin-card">
    <h2 class="card-header-title">Quick Actions</h2>
    <div class="quick-actions">
        <a href="/admin/pages.php?action=create" class="quick-action-card">
            <div class="icon"><i class="fas fa-plus-circle"></i></div>
            <div class="title">New Page</div>
        </a>
        <a href="/admin/posts.php?action=create" class="quick-action-card">
            <div class="icon"><i class="fas fa-pen"></i></div>
            <div class="title">New Post</div>
        </a>
        <a href="/admin/components.php" class="quick-action-card">
            <div class="icon"><i class="fas fa-puzzle-piece"></i></div>
            <div class="title">Components</div>
        </a>
        <a href="/admin/media.php" class="quick-action-card">
            <div class="icon"><i class="fas fa-upload"></i></div>
            <div class="title">Upload Media</div>
        </a>
        <a href="/admin/settings.php" class="quick-action-card">
            <div class="icon"><i class="fas fa-cog"></i></div>
            <div class="title">Settings</div>
        </a>
        <a href="/" target="_blank" class="quick-action-card">
            <div class="icon"><i class="fas fa-eye"></i></div>
            <div class="title">View Site</div>
        </a>
    </div>
</div>

<!-- Recent Pages -->
<div class="admin-card">
    <h2 class="card-header-title">Recent Pages</h2>
    <div class="table-container">
        <table class="table is-fullwidth admin-table">
            <thead>
                <tr>
                    <th>Title</th>
                    <th>Slug</th>
                    <th>Status</th>
                    <th>Actions</th>
                </tr>
            </thead>
            <tbody>
                <?php
                $recentPages = array_slice(\Models\Page::all(), 0, 5);
                foreach ($recentPages as $page):
                    ?>
                    <tr>
                        <td>
                            <strong><?= htmlspecialchars($page['title']) ?></strong>
                        </td>
                        <td>
                            <code>/<?= htmlspecialchars($page['slug']) ?></code>
                        </td>
                        <td>
                            <span class="status-badge is-<?= $page['status'] ?>">
                                <?= ucfirst($page['status']) ?>
                            </span>
                        </td>
                        <td>
                            <div class="action-buttons">
                                <a href="/admin/pages.php?action=edit&id=<?= $page['id'] ?>"
                                    class="button is-small is-info is-light">
                                    <span class="icon"><i class="fas fa-edit"></i></span>
                                </a>
                                <a href="/<?= htmlspecialchars($page['slug']) ?>" target="_blank"
                                    class="button is-small is-success is-light">
                                    <span class="icon"><i class="fas fa-external-link-alt"></i></span>
                                </a>
                            </div>
                        </td>
                    </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>
    <div class="has-text-right mt-4">
        <a href="/admin/pages.php" class="button is-primary is-light">View All Pages →</a>
    </div>
</div>

<!-- System Info -->
<div class="admin-card">
    <h2 class="card-header-title">System Information</h2>
    <div class="columns">
        <div class="column">
            <table class="table is-fullwidth">
                <tr>
                    <td><strong>PHP Version</strong></td>
                    <td><?= phpversion() ?></td>
                </tr>
                <tr>
                    <td><strong>Database</strong></td>
                    <td>SQLite</td>
                </tr>
                <tr>
                    <td><strong>Theme</strong></td>
                    <td><?= ucfirst(\Models\Meta::get(0, 'site', 'theme_preset') ?: 'Default') ?></td>
                </tr>
            </table>
        </div>
        <div class="column">
            <table class="table is-fullwidth">
                <tr>
                    <td><strong>Memory Limit</strong></td>
                    <td><?= ini_get('memory_limit') ?></td>
                </tr>
                <tr>
                    <td><strong>Upload Max</strong></td>
                    <td><?= ini_get('upload_max_filesize') ?></td>
                </tr>
                <tr>
                    <td><strong>CMS Version</strong></td>
                    <td>1.0.0</td>
                </tr>
            </table>
        </div>
    </div>
</div>

<?php
$content = ob_get_clean();
include __DIR__ . '/layouts/admin_layout.php';