#!/usr/bin/env php
<?php
/**
 * AI-Native CMS - List Presets CLI Tool
 * Shows available industry presets
 * 
 * Usage: php cli/list-presets.php
 */

if (php_sapi_name() !== 'cli') {
    die(json_encode(['success' => false, 'error' => 'CLI only']));
}

$presetsDir = __DIR__ . '/../presets';

echo "Available Industry Presets\n";
echo "==========================\n\n";

$presets = [
    'lawyer' => [
        'name' => 'Lawyer / Law Firm',
        'description' => 'Professional legal services website with practice areas, team, testimonials',
        'pages' => ['Home', 'About', 'Services', 'Contact'],
    ],
    'clinic' => [
        'name' => 'Clinic / Healthcare',
        'description' => 'Medical practice website with services, doctors, appointment booking',
        'pages' => ['Home', 'Services', 'Team', 'Contact'],
    ],
    'realtor' => [
        'name' => 'Real Estate Agency',
        'description' => 'Property listings website with search, featured properties, agent profiles',
        'pages' => ['Home', 'Listings', 'About', 'Contact'],
    ],
    'restaurant' => [
        'name' => 'Restaurant / Cafe',
        'description' => 'Restaurant website with menu, gallery, reservations, location',
        'pages' => ['Home', 'Menu', 'Gallery', 'Contact'],
    ],
    'pedagogue' => [
        'name' => 'Pedagogue / Therapist',
        'description' => 'Therapy/counseling practice with services, booking, resources',
        'pages' => ['Home', 'Services', 'About', 'Contact'],
    ],
];

foreach ($presets as $key => $preset) {
    $exists = is_dir($presetsDir . '/' . $key) ? '✅' : '⚠️ ';
    echo "$exists $key\n";
    echo "   Name: {$preset['name']}\n";
    echo "   Description: {$preset['description']}\n";
    echo "   Pages: " . implode(', ', $preset['pages']) . "\n\n";
}

echo "Usage:\n";
echo "  php cli/create-site.php --preset=lawyer --name=\"Client Name\"\n\n";

echo json_encode(['success' => true, 'presets' => array_keys($presets)]);
